/*------------------------------------------------------------------------------*
 * File Name:PlotSetup.c														*
 * Creation: CPY 6/12/2003														*
 * Purpose: OriginC Source C file for Plot Setup dialog							*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 7/30/03 PLOT_TYPE_LIST_SEL_SUPPORT										*
 *	CPY 8/17/03 ROW_NUMBER_ROW_ONLY_X_ALLOWED									*
 *	CPY 8/18/03 AUTO_ENTER_EDIT_WHEN_DATAPLOT_SELECTED							*
 *	CPY 8/21/03 QA70-5034 COL_WKS_CONTEXT_MENU_IMPROVEMENT						*
 *	RVD 8/25/2003 QA70-5042 v7.0674 DATAPLOT_LIMITS_DISPLAY						*
 *	CPY 9/6/03 v7.5686 RESIZEING_CLEAN_UP										*
 *	CPY 9/9/03 v7.5689 TERNARY_PLOT_USE_2D_TYPES								*
 *	RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY								*
 *	CPY 10/26/03 AUTO_SEL_LAST_ACTIVE_WKS_MATRIX								*
 *	CPY 9/6/04 QA70-6831 APPLY_BUTTON_SHOWING_IN_COL_LIST						*
 *	CPY 9/6/04 QA70-6831 REPLACE_PLOT_WITH_ANOTHER_WKS							*
 *	Jasmine 09/04/06 REMOVE_QUOTATION_MARK										*
 *	CPY 1/2/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES					*
 *	Jasmine 04/10/07 QA80-9597 v597b GET_WKS_FROM_DATA_PLOT						*
 *	Jasmine 04/16/07 QA80-9617 RESIZE_DIALOG_AFTER_LOAD_SIZE					*
 *	Jasmine 06/04/07 QA70-9560 FIX_XYZ_CONTOUR_BUG_P1							*
 *	Folger 02/19/08 QA80-11121 LOCALIZED_ADD_WITH_PLOT_CATEGORY					*
 *  Kyle 07/18/08 	CHANGE_INFO_COLUMN_SHOW_STYLE								*
 *  Kyle 07/21/08 ADD_REPLACE_BUTTON_TO_DIALOG									*
 *	Kyle 07/22/08 ADD_TWO_FUNCTION_TO_SAVE_AND_LOAD_SETTING_OF_INFO_COLS_SHOW	*
 *	Kyle 07/22/08 CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
 *	Kyle 07/23/08 HIDE_SOME_INFO_COLS_WHILE_IT_IS_NOT_WKS						*
 *	Kyle 07/29/08 HIDE_ALL_COLS_WHEN_NO_CONTENT									*
 *	Kyle 07/30/08 ONREADY_OF_COLLISTCONTROL_CHANGED_AND_UPDATELIST_CALLED_IN_IT	*
 *	Kyle 07/31/08 UPDATE_LIST_WHEN_NO_CONTENT									*
 *	Jasmine 07/31/08 QA80-11817-P6 ROW#_IS_NOT_CLEAR_INDICATE_SAMPLING_INTERVAL_AS_X
 *	Jasmine 08/08/08 QA80-11974 NO_NEED_REMEMBER_DESIGNATION					*
 *	Jasmine 08/11/08 QA80-11948-P1 ENABLE_APPLY_WHEN_PLOT_CHANGE				*
 *	Jasmine 09/01/08 QA880-11938 ADD_CHANGE_DESIGNATION_MODE_BTN				*
 *	Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION				*
 *	Jasmine 09/03/08 QA80-12131 NOT_SELECT_ACTIVE_PLOT_WHEN_ADD_PLOT_TO_LAYER	*
 *	Jasmine 09/05/08 QA80-11938 REMEMBER_DESIGNATION_MODE						*
 *	Jasmine 10/06/08 MISSING_0_MAKE_ArrangeControlsLeftRight_FAIL				*
 *	Jasmine 10/08/08 QA80-12163 VC_ALLOW_ADDING_PLOTS_WHEN_SELECTE_DATAPLOT		*
 *	Jasmine 10/16/08 QA80-12354 NO_COL_SELECTED_ON_INIT							*
 *	Jasmine 10/16/08 QA80-12354 TOO_LATE_TO_ENABLE_ADDREPLACE_BTN_WHEN_SHOW_BTN	*
 *	Jasmine 11/04/08 8.0965 ADD_BTN_ENABLE_IMPROPERLY							*
 *	Jasmine 11/28/08 v8.0980d QA80-12437 SHOULD_REMEMBER_DESIGNATION_AND_AUTO_DETECT_LATER
 *	Kenny 03/06/2009 REMOVE_TEXT_SHOW_FROM_CONTEXT_MENU							*
 *	Jasmine 03/06/09 QA80-13219-P3 BRING_BACK_AUTO_X_MENU						*
 *	Kyle 06/17/2009 QA80-13405 CHECKING_IF_LEGEND_OR_SPECTRUM_EXIST_BEFORE_UPDATING_GRAPH
 *	Kyle 06/23/2009 QA80-13831 SHOULD_LOAD_CHECK_BOX_SETTINGS_IN_OLD_ORDER_AND_THEN_CHANGE_IT_TO_NEW_ORDER
 *	Jasmine 07/16/09 #13952 HIDDEN_CONTROL_IS_IGNORED_IN_MOVING_AND_APPEAR_IN_BAD_POSITION 
 *	Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE								*
 *	Jasmine 08/06/09 QA81-13749 AUTO_APPLY_DESTINATIONS_IN_COL_LIST				*
 *	Jasmine 08/14/09 IDC_SELCOLS_PLOTS_LABEL_WIDEN								*
 *	Kenny 08/17/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING				*
 *	Kenny 08/25/2009 QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC				*
 *	Jasmine 09/21/09 QA81-14344 LAYER_BIT_WILL_AFFECT_COL_DESIGNATION			*	
 *	Jasmine 10/28/09 QA80-14467 COL_DESIGNATION_NEED_UPDATE_BY_PLOT_TYPE		*
 *	Jasmine 12/01/09 QA80-14144 UPDATE_WKS_LIST_AFTER_LOAD_REGIST_VALUE			*
 *	Jasmine 12/01/09 QA80-14762 GetDataPlots_MAY_FAIL							*
 *	Jasmine 01/15/10 LAST_SEL_BLOCK_PLOTSETUP_OPEN								*
 *	Jasmine 02/04/10 QA81-14754-P4 SHOW_COMMON_COL_HINT							*
 *	Jasmine 02/04/10 QA81-14467-P2 NOT_RESET_COL_DESIG_OF_SEL_PLOT				*
 *	Folger 04/13/10 REGULAR_EVENT_FUNCS_SHOULD_DO_NOTHING_AFTER_ON_DESTROY		*
 *	Jasmine 08/27/10 ORG-928 PLOTS_LABEL_IS_TOO_BLG_TO_SHOW_IN_OLD_LOGIC		*
 *	Jasmine 08/27/10 ORG-928 PLOT_TYPES_STYLEHOLDER_WAS_IGNORED					*
 *	Hong 10/29/10 ORG-974 FIX_PLOTSETUP_OPEN_WITH_COLLST_EMPTY_WITH_WXGRID		*
 *------------------------------------------------------------------------------*/
 
#include <origin.h>
/////////////////////////////////////////////////////////////////////////////////////
#include "DialogEx.h" // CPY 7/2/04 consoidate all dialog related headers into a single one

#include <Profiler.h>
////////////////////////////////////////////////////////////////////////////////////////////////
// string localization section
// here we define all the strings that is longer and best to use macro, other strings can
// appear directly inside code using the _L() macro
#define _CAT "Plot Setup"	// category for localization table, not always needed, used only for short string that might otherwise be confusing
#define SCP_DLG_TITLE_LEFT_NEW_PLOT 		_L("Plot Setup: Select Data to Create New Plot")
#define SCP_DLG_TITLE_LEFT_LAYER_CONTENTS	_L("Plot Setup: Configure Data Plots in Layer")

#define SCP_DLG_X_ROW_NUM_TITLE				_L("Use Row Number as X")
#define	SCP_DLG_X_ROW_NUM_LABEL				_L("Please enter initial X value and increment")
////////////////////////////////////////////////////////////////////////////////////////////////

// we need to indicate function to be diff from dataset, but there is no such EXIST type in 
// Origin, so we will steal another EXIST const that is not being used
//#define EXIST_FUNC_PLOT		EXIST_PLOT
//
//----- communication by PostMessage between controls and dialog
//WM_USER_ON_CONTROL_CHANGE wParam
enum {ON_CONTROL_CHANGE_COL_DESIGNATIONS = 1};


#define HOUR_GLASS			waitCursor junk;
#define PROFILE_HRGLASS		HOUR_GLASS	//Profiler junk;

//---- CPY 4/15/07 REMOVE_PRINTF
#define _DBMSG(_STR)	//out_str(_STR)	
//----

#define CHANGE_DESIGNATION_MODE_BTN			///Jasmine 09/12/08 QA80-11938 
#define CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS		///Jasmine 10/08/08 QA80-12163 VC_ALLOW_ADDING_PLOTS_WHEN_SELECTE_DATAPLOT

//---- CPY 9/9/03 v7.5689 TERNARY_PLOT_USE_2D_TYPES
//---- 
#include "ColDesignations.h"		// middle pane, PlotDesignations, or Column List, this class supports the control to pick XY checkboxes
#include "WksListControl.h"			// top pane, listing of worksheets
#include "PlotTypeListControl.h"	// left list control of middle of dialog, manage the plot types
#include "PlotListControl.h"		// bottom pane, Layer Contents, and Plots List


//////-------- CPY 7/30/03
// the following are implemented here because of class pointer ColListControl, so menu needs ColListControl, and has to be done outside class declaration
enum {
	CLCMENU_APPLY_DESTINATIONS, 
	CLCMENU_AUTO_APPLY_DESTINATIONS, 	///Jasmine 08/06/09 QA81-13749 AUTO_APPLY_DESTINATIONS_IN_COL_LIST	
	
	CLCMENU_CHECK_ALL_UP, 
	CLCMENU_CHECK_ALL_DOWN, 
		CLCMENU_SEPARATOR0, 
	CLCMENU_CLEAR_ABOVE_DESIGNATIONS, 
	CLCMENU_CLEAR_BELOW_DESIGNATIONS, 
	CLCMENU_CLEAR_ALL_DESIGNATIONS, 
		CLCMENU_SEPARATOR, 
		
	///Jasmine 03/06/09 QA80-13219-P3 BRING_BACK_AUTO_X_MENU
	CLCMENU_ROW_AS_X,		///Jasmine 08/01/08 ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
		CLCMENU_SEPARATOR3, 
	///End BRING_BACK_AUTO_X_MENU
	
	CLCMENU_SHOW_ALL_COLS, 
		CLCMENU_SEPARATOR1, 
	CLCMENU_ERR_X, 
	CLCMENU_ERR_Y_POS_NEG, 
	CLCMENU_SHOW_COLUMN_POSITION,		//Kyle 07/18/08 	CHANGE_INFO_COLUMN_SHOW_STYLE
		CLCMENU_SEPARATOR2, 
	CLCMENU_INCREASE,
	CLCMENU_DECREASE,
	
	CLCMENU_END
};


///Kyle 07/18/08 	CHANGE_INFO_COLUMN_SHOW_STYLE
#define IDC_SHOW_MENU_BEGIN         (OC_MENURANGE_BEGIN + 1000)
ColListControlSubMenu::ColListControlSubMenu(const vector<string> & vsColNames, const vector<bool> & vbShowCols, const vector<int> &vnHiddenInfoCols)
{
	//int nTotal = INFO_COL_END - INFO_COL_BEGIN + 1;
	int nNames = vsColNames.GetSize(), nShows = vbShowCols.GetSize();
	if(nNames != nShows)
		error_report("vsColNames and vbShowCols have different size");
	int nTotal = min(nNames, nShows);
	int nCmd = IDC_SHOW_MENU_BEGIN;
	int nFlags;
	vector<uint> vecIndex;
	for(int ii = 0; ii < nTotal; ii++)
	{
		if(INFO_COL_NAME == ii)
			continue;
		
		nFlags = vbShowCols[ii]? MF_CHECKED : MF_UNCHECKED;
		///Kyle 07/23/08 HIDE_SOME_INFO_COLS_WHILE_IT_IS_NOT_WKS
		if(vnHiddenInfoCols.Find(vecIndex, ii)>0 )
			nFlags |= (MF_DISABLED | MF_GRAYED);
		///End HIDE_SOME_INFO_COLS_WHILE_IT_IS_NOT_WKS
		Add( vsColNames[ii], OnSubMenuItem, nFlags, nCmd++);
	}
	Add(NULL, OnSubMenuItem, MF_SEPARATOR, nCmd++);
	Add(_L("Show All"), OnSubMenuItem, 0, nCmd++);
	
	m_nItems = nCmd - IDC_SHOW_MENU_BEGIN;
}

bool ColListControlSubMenu::GetCommand(int& nChoice, int nSelCmd)
{
	int nCmd = nSelCmd - IDC_SHOW_MENU_BEGIN + 1;//1 offset
	if(nCmd > 0 && nCmd <= m_nItems)
	{
		nChoice = nCmd;
		return true;
	}
	return false;
}
///End CHANGE_INFO_COLUMN_SHOW_STYLE
bool ColListControlMenu::GetCommand(int& nChoice)
{
	if(m_nChoice >= CLCMENU_APPLY_DESTINATIONS && m_nChoice < CLCMENU_END)
	{
		nChoice = m_nChoice;
		return true;
	}
	return false;
}

///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
///Kyle 07/18/08 	CHANGE_INFO_COLUMN_SHOW_STYLE
//ColListControlMenu::ColListControlMenu(ColListControl* pCLcntrl, int nRow, int nCol)
#ifdef CHANGE_DESIGNATION_MODE_BTN
ColListControlMenu::ColListControlMenu(ColListControl* pCLcntrl, int nRow, int nCol, bool bDesignation, const Menu & subMenu)
#else
ColListControlMenu::ColListControlMenu(ColListControl* pCLcntrl, int nRow, int nCol, const Menu & subMenu)	
#endif//CHANGE_DESIGNATION_MODE_BTN
///End CHANGE_INFO_COLUMN_SHOW_STYLE
///End DEFAULT_MODE_AUTO_GET_DESIGNATION
{
	m_nChoice = -1;
	UINT nFlags = 0;
	DWORD dwEnable = 0;
//	Button btnApplyWks = pCLcntrl->GetItem(IDC_SELCOLS_APPLY_WKS);
//	if(btnApplyWks)
//		nFlags = btnApplyWks.Check?MF_CHECKED : MF_UNCHECKED;
#ifdef CHANGE_DESIGNATION_MODE_BTN
	if(bDesignation)	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
#endif//CHANGE_DESIGNATION_MODE_BTN
	{
		Add(_L("Apply Designations"), OnMenuItem, nFlags);
		
		///Jasmine 08/06/09 QA81-13749 AUTO_APPLY_DESTINATIONS_IN_COL_LIST	
		nFlags = pCLcntrl->m_chkApplyWks.Check? MF_CHECKED : MF_UNCHECKED;
#ifdef 	CHANGE_DESIGNATION_MODE_BTN		
		if(!bDesignation)	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
			nFlags = MF_DISABLED | MF_GRAYED;
#endif//CHANGE_DESIGNATION_MODE_BTN
		Add(_L("Auto Apply Designations"), OnMenuItem, nFlags);		
		///End AUTO_APPLY_DESTINATIONS_IN_COL_LIST	
		
		nFlags = nRow < 0? MF_DISABLED | MF_GRAYED : MF_ENABLED;
		Add(_L("Set All to Top"), OnMenuItem, nFlags);
		Add(_L("Set All to Bottom"), OnMenuItem, nFlags);
	Add(NULL, OnMenuItem);//--------------- separator
		nFlags = pCLcntrl->GetNumDesignationsAssigned()? MF_ENABLED : MF_DISABLED | MF_GRAYED;
		if(MF_ENABLED == nFlags && nRow < 0) // outside
			nFlags = MF_DISABLED | MF_GRAYED;	
		Add(_L("Clear All to Top"), OnMenuItem, nFlags);
		Add(_L("Clear All to Bottom"), OnMenuItem, nFlags);
		// reset
		nFlags = pCLcntrl->GetNumDesignationsAssigned()? MF_ENABLED : MF_DISABLED | MF_GRAYED;
		Add(_L("Clear All Designations"), OnMenuItem, nFlags);
		
	Add(NULL, OnMenuItem);//--------------- separator
	
	///Jasmine 03/06/09 QA80-13219-P3 BRING_BACK_AUTO_X_MENU
	/////Jasmine 08/01/08 ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
	///*	
		//dwEnable = pCLcntrl->IsAllowX()? MF_ENABLED : MF_DISABLED | MF_GRAYED;
		dwEnable = pCLcntrl->IsRowNumberRowAllowed()? MF_ENABLED : MF_DISABLED | MF_GRAYED;
		nFlags = pCLcntrl->m_chkAddRowNumX.Check?MF_CHECKED : MF_UNCHECKED;
		Add(_L("Allow Row# as X"), OnMenuItem, nFlags | dwEnable);
	Add(NULL, OnMenuItem);//--------------- separator
	//*/
	/////End ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
	///End BRING_BACK_AUTO_X_MENU
	
			nFlags = pCLcntrl->m_chkShowAllCols.Check? MF_CHECKED : MF_UNCHECKED;
			dwEnable = pCLcntrl->IsWorksheetPages()? MF_ENABLED : MF_DISABLED | MF_GRAYED;
		Add(_L("Show Disregarded(and hidden) Columns"), OnMenuItem, nFlags | dwEnable);	//CLCMENU_SHOW_ALL_COLS
	Add(NULL, OnMenuItem);//--------------- separator
			dwEnable = pCLcntrl->IsAllowErrbars()? MF_ENABLED : MF_DISABLED | MF_GRAYED;
			nFlags = pCLcntrl->m_chkXErrBars.Check?MF_CHECKED : MF_UNCHECKED;
		Add(_L("X Error Bars"), OnMenuItem, nFlags | dwEnable);
			nFlags = pCLcntrl->m_chkPosNegErrBars.Check?MF_CHECKED : MF_UNCHECKED;
		Add(_L("Y Error Bars Plus/Minus"), OnMenuItem, nFlags | dwEnable);
	}
	
	AddPopup( _L("Show Info Columns"), subMenu);						///Kyle 07/18/08 	CHANGE_INFO_COLUMN_SHOW_STYLE
Add(NULL, OnMenuItem);//--------------- separator
		Add(STR_INCREASE_HEIGHT, OnMenuItem);
		Add(STR_DECREASE_HEIGHT, OnMenuItem);		
}

void ColListControl::OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
{
	int nRow = m_flx.MouseRow;
	int nCol = m_flx.MouseCol;
	if(MK_RBUTTON == nButton && 0 == nShift)
	{
		int nx = XTwipsToPixels(X);
		int ny = YTwipsToPixels(Y);
		ClientToScreen(nx, ny);
		//printf("nx = %d, ny = %d\n", nx, ny);
		///Kyle 07/18/08 	CHANGE_INFO_COLUMN_SHOW_STYLE
		//ColListControlMenu	myMenu(this, nRow, nCol);
		//myMenu.TrackPopupMenu(0,  nx, ny, GetDlgSafeHwnd());
		ColListControlSubMenu subMenu(m_vsInfoCols, m_vbInfoColsShow, m_vnUnavailableInfoCols);
#ifdef CHANGE_DESIGNATION_MODE_BTN		
		ColListControlMenu	myMenu(this, nRow, nCol, m_bDesignation, subMenu);///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
#else
		ColListControlMenu	myMenu(this, nRow, nCol, subMenu);	
#endif//CHANGE_DESIGNATION_MODE_BTN
		int st;
		myMenu.TrackPopupMenu(0,  nx, ny, GetDlgSafeHwnd(), &st);
		///End CHANGE_INFO_COLUMN_SHOW_STYLE
		
		int nCmd;
		
		///Kyle 07/18/08 	CHANGE_INFO_COLUMN_SHOW_STYLE 
		if(subMenu.GetCommand(nCmd,st))
		{
			//int nTotal = INFO_COL_END - INFO_COL_BEGIN + 1;
			//if(nCmd >= nTotal)
				//m_vbInfoColsShow = true;
			//else
				//m_vbInfoColsShow[nCmd] = m_vbInfoColsShow[nCmd] ? false:true;
			OnInfoColsShow(nCmd);
			return;
		}
		///End CHANGE_INFO_COLUMN_SHOW_STYLE
		
		if(myMenu.GetCommand(nCmd))
		{
#ifdef CHANGE_DESIGNATION_MODE_BTN	
			if(!m_bDesignation)		///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
				nCmd += CLCMENU_SHOW_COLUMN_POSITION;
#endif//CHANGE_DESIGNATION_MODE_BTN			
			switch(nCmd)
			{
			case CLCMENU_APPLY_DESTINATIONS:
				ApplyWksColDesignations(true);
				break;
			///Jasmine 08/06/09 QA81-13749 AUTO_APPLY_DESTINATIONS_IN_COL_LIST	
			case CLCMENU_AUTO_APPLY_DESTINATIONS:
				OnAutoApplyColDesignations();
				break;
			///End AUTO_APPLY_DESTINATIONS_IN_COL_LIST
			case CLCMENU_CLEAR_ALL_DESIGNATIONS:
				ClearColDesignations();
				break;
			case CLCMENU_CLEAR_ABOVE_DESIGNATIONS:
				ClearColDesignations(nRow, nCol, false);
				break;
			case CLCMENU_CLEAR_BELOW_DESIGNATIONS:
				ClearColDesignations(nRow, nCol, true);
				break;				
			case CLCMENU_CHECK_ALL_UP:
				SetColDesginations(nRow, nCol, false);
				break;
			case CLCMENU_CHECK_ALL_DOWN:
				SetColDesginations(nRow, nCol, true);
				break;				
			case CLCMENU_SHOW_ALL_COLS:
				m_chkShowAllCols.Check = m_chkShowAllCols.Check?false:true;
				updateShowColsRows();
				updateDesignations(true);
				break;
			case CLCMENU_ERR_X:
				m_chkXErrBars.Check = m_chkXErrBars.Check?false:true;
				break;
			case CLCMENU_ERR_Y_POS_NEG:
				m_chkPosNegErrBars.Check = m_chkPosNegErrBars.Check?false:true;
				break;
			///Jasmine 03/06/09 QA80-13219-P3 BRING_BACK_AUTO_X_MENU
			case CLCMENU_ROW_AS_X:	///Jasmine 08/01/08 ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
				m_chkAddRowNumX.Check = m_chkAddRowNumX.Check?false:true;
				break;
			///End BRING_BACK_AUTO_X_MENU
			case CLCMENU_INCREASE:
				PostDlgMessage(WM_USER_RESIZE_CONTROLS, 1 , LPARAM_RESIZE_CONTROLS_INCREASE);
				break;
			case CLCMENU_DECREASE:
				PostDlgMessage(WM_USER_RESIZE_CONTROLS, 1 , LPARAM_RESIZE_CONTROLS_DECREASE);
				break;					
			}
			if(CLCMENU_ERR_X == nCmd || CLCMENU_ERR_Y_POS_NEG == nCmd)
				OnChangeErrBarOptions();
			///Jasmine 03/06/09 QA80-13219-P3 BRING_BACK_AUTO_X_MENU
			if(CLCMENU_ROW_AS_X == nCmd)	///Jasmine 08/01/08 ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
				OnChangeAddRowNumbers();
			///End BRING_BACK_AUTO_X_MENU
		}
		return;
	}
	//----- CPY 8/17/03 ROW_NUMBER_ROW_ONLY_X_ALLOWED
	if(nRow == getRowNumberRow() && !isXCol(nCol))
		return;
	//-----
	GridListControl::OnBeforeMouseDown(nButton, nShift, X, Y, pCancel);
}
//////-------- end CPY 7/30/03

//------ CPY 8/21/03 QA70-5034 COL_WKS_CONTEXT_MENU_IMPROVEMENT
//	void ClearColDesignations(int nRow = -1, int nCol = -1, bool bAllDown = false, bool bKeepX = false, bool bRepaint = true);
void ColListControl::ClearColDesignations(int nRowCurrent, int nCol, bool bAllDown, bool bKeepX, bool bRepaint)// = -1 = -1 = false  false true);
{
	HOUR_GLASS
	
	int nR1 = m_flx.FixedRows;
	int nR2 = m_flx.Rows;
	
	if(nRowCurrent >= nR1)
	{
		bKeepX = true;
		if(bAllDown)
			nR1 = nRowCurrent;
		else
			nR2 = nRowCurrent+1;
	}
	for(int nRow = nR1; nRow < nR2; nRow++)
	{
		if(bKeepX && getColDesignation(nRow) == COLDESIG_X)
			continue;
		setDesignationRadioChoice(nRow, 0);
	}
	if(bRepaint)
		updateDesignations();
	notifyDlgOnDesignationChanges();
}
void ColListControl::SetColDesginations(int nRowCurrent, int nCol, bool bAllDown, bool bRepaint)// otherwise all up, = true
{
	HOUR_GLASS
	
	int nR1 = m_flx.FixedRows;
	int nR2 = m_flx.Rows;
	if(bAllDown)
		nR1 = nRowCurrent;
	else
		nR2 = nRowCurrent+1;
	
	for(int nRow = nR1; nRow < nR2; nRow++)
	{
		setDesignationRadioChoice(nRow, nCol);
	}
	if(bRepaint)
		updateDesignations();
	
	notifyDlgOnDesignationChanges();
}

string ColListControl::getColHeadingTooltips(int nCol)
{
	string str;
	int nDesignation = getDesignationOfCol(nCol);
	if(nDesignation >= 0)
	{
		switch(nDesignation)
		{
		case COLDESIG_LABEL:
			str = _L("Data Label");
			break;
		case COLDESIG_SIZE:
			str = _L("Symbol Size");
			break;
		case COLDESIG_COLOR:
			str = _L("Symbol Color");
			break;
		case COLDESIG_VECTOR_ANGLE:
			str = _L("Angle");
			break;
		case COLDESIG_VECTOR_MAGNITUDE:			
			str = _L("Magnitude");
			break;
		}
	}
	return str;
}

//------

#define		DBG_TREE_OUT(_tr, _lpcsMsg)		//tree_dump(_tr, _lpcsMsg, 4);

///////////// WAIT_FIX, this is needed until we can have class static member function and static data member
static	int s_nLeft = -1, s_nTop = -1;

static	bool get_n_box_event(TreeNode& myTree, int nRow, int nType, Dialog& dlgGetNBox)
{
	if(nRow < 0 && s_nLeft> 0 && s_nTop > 0) // init
	{
		RECT r1;
		Window wnd = dlgGetNBox.GetWindow();
		wnd.GetWindowRect(&r1);
		OffsetRect(&r1, s_nLeft - r1.left, s_nTop - r1.top);
		wnd.MoveWindow(&r1);
		s_nLeft = s_nTop = -1;
	}
	return false;
}
/////////////

#define		STR_AVAIL_DATA_CHOICE			"AvailData"
#define		STR_DATA_PLOTS					"DataPlots"

//////////////////////////////
//////////////////////////////
#define		STR_LAYER_NODE_NAME_PREFIX		"Layer"
#define		STR_LAYER_NODE_NAME_DISPLAY		_LC("Layer", _CAT)

BOOL	init_tree_num_layers(TreeNode &tr, int nNumLayers = 1)
{
	if (nNumLayers < 1)
		nNumLayers = 1;
	
	tr.RemoveChild(STR_DATA_PLOTS);
	TreeNode		trRoot = tr.AddNode(STR_DATA_PLOTS);
	if (!trRoot.IsValid())
	{
		ASSERT(FALSE);
		return FALSE;
	}
	
	for (int ii = 0; ii < nNumLayers; ii++)
	{
		string			strLayerNodeName;
		string			strLabel;
		//strLayerNodeName.Format("Layer%d", ii);
		strLayerNodeName.Format("%s%d", STR_LAYER_NODE_NAME_PREFIX, ii);
		TreeNode		trLayerNode = trRoot.AddNode(strLayerNodeName);
		if (trLayerNode.IsValid())
		{
			strLabel.Format("%s %d", STR_LAYER_NODE_NAME_DISPLAY, ii + 1);
			trLayerNode.SetAttribute(STR_LABEL_ATTRIB, strLabel);
			// Let the internal code know that this is a branch (since it will
			// be empty for now)
			trLayerNode.SetAttribute(STR_ID_ATTRIB, ONODETYPE_BRANCH);
		}
		else
			ASSERT(FALSE);
	}

	return TRUE;
}

static bool is_plot_list_empty(TreeNode &tr)
{
	foreach (TreeNode trLayer in tr.Children)
	{
		if(trLayer.GetNodeCount() > 0)
			return false;
	}
	return true;
}
	
typedef	void (*PFNApplySystemThemeToPage)(OriginObject& obj);
static bool	apply_plot_list_tree_to_page(GraphPage &pg, TreeNode &tr, DWORD dwCtrl)
{
	if (!pg)
	{
		ASSERT(FALSE);
		return FALSE;
	}

	HOUR_GLASS
	
	foreach (TreeNode trLayer in tr.Children)
	{
		string			strName = trLayer.tagName;
		string			strPrefix;
		
		int				nIndex = string_to_prefix_end_number(strPrefix.GetBuffer(MAXLINE), strName);
		strPrefix.ReleaseBuffer();
		
		if (strPrefix.CompareNoCase(STR_LAYER_NODE_NAME_PREFIX) == 0)
		{
			GraphLayer	grl = pg.Layers(nIndex);
			if (grl)
				grl.AddPlots(trLayer, dwCtrl);
			else
				return false;	// cannot find the layer
		}
		else
			return false;	// there are other nodes?
	}
	
	if( dwCtrl & ADDPLOTSFROMTREE_NEW )
	{
		PFNApplySystemThemeToPage pfn = Project.FindFunction("ApplySystemThemeToPage", "Originlab\\OriginEvents.c");
		if( pfn )
			pfn(pg);
	}
	
	return true;
}
//////////////////////////////

// this function opens the Plot Setup dialog
//when calling from a graph layer, this dialog work with treenodes, 
//
// return 0 if user cancel, otherwise, return the DWORD that will be passed into grl.AddPlots
// nExVal = -1 to indicate that we are using template library
static DWORD SelColsPlottingDlg(bool bNewPlot, TreeNode& trPlotList, int nPlotID, int nExVal, HWND hWndParent = NULL)
{	
	SelColsForPlottingDlg MyDlg(bNewPlot, trPlotList, nPlotID, nExVal);
	
 	return MyDlg.DoModalEx(hWndParent);
}

static bool get_gpage_plot_contents_and_check_plot_type(const GraphPage &pg, TreeNode &trPlots, int& nPlotType)
{
	HOUR_GLASS
	
	int nTemplatePlotType = gpage_get_plots(pg, trPlots);
		
	if ( 0 == nTemplatePlotType )
		return false;
	if(0 == nPlotType || IDM_PLOT_UNKNOWN == nPlotType)
	{
		if(nTemplatePlotType != IDM_PLOT_UNKNOWN)
			nPlotType = nTemplatePlotType;
		else
			nPlotType = 0;
	}
	return true;
}
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//
// Main function
// this function is called from inside Origin to bring up the Plot Setups dialog
// 
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
BOOL PlotSetup(BOOL bNewPlot = FALSE, int nPlotID = IDM_PLOT_LINE, LPCSTR lpcszTemplate = NULL, HWND hWndParent = NULL)
{
	///Jasmine 01/15/10 LAST_SEL_BLOCK_PLOTSETUP_OPEN
	string strLT;
	strLT.Format("if( exist(%s$) ){%%E = %s$; del -vs %s}", TEMP_LT_VAR_LAST_SEL, TEMP_LT_VAR_LAST_SEL, TEMP_LT_VAR_LAST_SEL);
	LT_execute(strLT);
	///End LAST_SEL_BLOCK_PLOTSETUP_OPEN
				
	Tree	trPlots;
	DWORD	dwAddPlotCntrl = 0;

	if(!bNewPlot) // open from graph window, layer contents
	{
		//Tree		trPage;
		GraphPage	pg = Project.Pages();
		bool		bFromLayerContents = 0==nPlotID? true : false;
		
		if ( !get_gpage_plot_contents_and_check_plot_type(pg, trPlots, nPlotID) )
			return FALSE;
		
		if(bFromLayerContents)
			nPlotID = 0; // this is the only way to indicate that we are from layer contents
		
		if(dwAddPlotCntrl = SelColsPlottingDlg(false, trPlots, nPlotID, 0, hWndParent))
		{
			apply_plot_list_tree_to_page(pg, trPlots.DataPlots, dwAddPlotCntrl);
			return TRUE;
		}
		return FALSE;
	}
	//
	// from here on, we are making new plots, so no current graph window to be considered, a new graph window is always created
	//
	string strTemplate = lpcszTemplate; // possible TemplateName:nExval, template name might be followed by int value that specify additional plotting info
	int nExVal = 0; // additional plotting info
	strTemplate.TrimLeft('"');		///Jasmine 09/04/06 REMOVE_QUOTATION_MARK
	strTemplate.TrimRight('"');
	if(strTemplate.GetLength() > 3) // assume template name of at least 2 chars, like "AB:3"
	{
		int nExValPos = strTemplate.ReverseFind(':');
		if(nExValPos > 1) // to avoid "c:\c\vc32\line.otp"
		{
			nExVal = atoi(strTemplate.Mid(nExValPos + 1));
			strTemplate = strTemplate.Left(nExValPos);
		}
	}
	string strTemplatePath = GetFilePath(strTemplate); 
	bool bTemplateLib = strTemplatePath.IsEmpty()? false:true;
	GraphPage gp;
	BOOL bWasModified = Project.IsModified(); /// TD 02-29-2008 QA80-11069 BLOCK_DIRTY_DOC_MORE_WORK
	/// Kenny 08/25/2009 QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
	//if(!gp.Create(strTemplate, CREATE_HIDDEN))
	if(!gp.Create(strTemplate, CREATE_HIDDEN|CREATE_ENUM_EXIST_PAGE))
	/// End QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
		return false;
	
	if(bTemplateLib)
		nExVal = -1;// nExVal = -1 to indicate template library

	if(get_gpage_plot_contents_and_check_plot_type(gp, trPlots, nPlotID))
	{				
		dwAddPlotCntrl = SelColsPlottingDlg(true, trPlots, nPlotID, nExVal, hWndParent);
		if(dwAddPlotCntrl && trPlots.DataPlots.IsValid()) // = 0 if user cancel
		{
			gp.SetShow();
			apply_plot_list_tree_to_page(gp, trPlots.DataPlots, dwAddPlotCntrl);
			if(dwAddPlotCntrl & ADDPLOTSFROMTREE_NEW)
			{
				///Kyle 06/17/2009 QA80-13405 CHECKING_IF_LEGEND_OR_SPECTRUM_EXIST_BEFORE_UPDATING_GRAPH
				//gp.LT_execute("legend -s");
				GraphLayer gl = gp.Layers();
				if(gl.GraphObjects("Spectrum1"))
					gp.LT_execute("Spectrum");
				else if(gl.GraphObjects(GO_LEGEND_NAME))
					gp.LT_execute("legend -s");
				///End CHECKING_IF_LEGEND_OR_SPECTRUM_EXIST_BEFORE_UPDATING_GRAPH
			}
			return true;
		}
		gp.Destroy();
		/// TD 02-29-2008 QA80-11069 BLOCK_DIRTY_DOC_MORE_WORK
		//restore o plot destroyed:
		if(!bWasModified)
			Project.ClearModified();
		/// end BLOCK_DIRTY_DOC_MORE_WORK
	}
	return false;
}

#define OFFSET_WKS_LIST_SUPPORT_ITEMS 1
//---- CPY 1/2/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES
//#define OFFSET_COL_LIST_SUPPORT_ITEMS 4
#define OFFSET_COL_LIST_SUPPORT_ITEMS 5
#define STR_COMMON_COL_MODE "CommonColMode"
//----
#define OFFSET_COL_LIST_LAYER_CONTENTS 1


static 	uint s_nWksListCntrlIDs[] = {IDC_SELCOLS_WKSTREE, IDC_SELCOLS_AVAILABLE_DATA_LABEL, IDC_SELCOLS_AVAILABLE_DATA,  
									IDC_SELCOLS_INCLUDE_SHORTCUT, 	///Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE
									IDC_SELCOLS_APPLY_WKS_LABEL, 0};//IDC_SELCOLS_APPLY_WKS, 0};
//---- CPY 1/2/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES
//static	uint s_nColListCntrlIDs[] = {IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_SHOW_DATA, IDC_SELCOLS_COLS_LABEL, IDC_SELCOLS_COLS, IDC_SELCOLS_PLOT_TYPES_LABEL, IDC_SELCOLS_PLOT_TYPES,0};//, IDC_SELCOLS_X_ERR, IDC_SELCOLS_POS_NEG_ERR, IDC_SELCOLS_ADD_ROW_NUMBER, 0};
static	uint s_nColListCntrlIDs[] = {IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_SHOW_DATA, IDC_SELCOLS_COMMON_COL_CHOICE, IDC_SELCOLS_COLS_LABEL, 
IDC_SELCOLS_COLS, IDC_SELCOLS_PLOT_TYPES_LABEL, IDC_SELCOLS_PLOT_TYPES, IDC_SELCOLS_DESIGNATION, 0};	///Jasmine 09/01/08 QA880-11938 ADD_CHANGE_DESIGNATION_MODE_BTN
//---- end POPUP_MENU_FOR_COMMON_COL_CHOICES

//-------- CPY 8/18/03 AUTO_ENTER_EDIT_WHEN_DATAPLOT_SELECTED
//static 	uint s_nCntrlButtons[] = {IDC_SELCOLS_ADD, IDC_SELCOLS_REPLACE, IDC_SELCOLS_EDIT, 0};
///Kyle 07/22/08 CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
//static 	uint s_nCntrlButtons[] = {IDC_SELCOLS_ADD, IDC_SELCOLS_REPLACE, 0};
#ifdef CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
static 	uint s_nCntrlButtons[] = {IDC_SELCOLS_ADD, IDC_SELCOLS_REPLACE, 0};
#else
static 	uint s_nCntrlButtons[] = {IDC_SELCOLS_ADD, 0};
#endif
/// CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
//-------- end

//static 	uint s_nCntrlButtonsShowPlotList[] = {IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_ADD, IDC_SELCOLS_REPLACE, IDC_SELCOLS_EDIT, 0};
///Kyle 07/22/08 CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
//static 	uint s_nCntrlButtonsShowPlotList[] = {IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_ADD, IDC_SELCOLS_REPLACE, 0};
#ifdef CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
static 	uint s_nCntrlButtonsShowPlotList[] = {IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_ADD, IDC_SELCOLS_REPLACE, 0};
#else
static 	uint s_nCntrlButtonsShowPlotList[] = {IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_ADD, 0};
#endif
///End CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
static  uint s_nCtrlsVertResize[] = {IDC_SELCOLS_WKSTREE, IDC_SELCOLS_COLS, IDC_SELCOLS_PLOTS, 0};
#define TOTAL_NUM_OF_PANELS  		3

#define IDC_SELCOLS_SHOW_COLS	IDC_SELCOLS_SHOW_PLOTS

//--- CPY 9/26/03 EDIT_PLOT_SHOW_HIGHLIGHT_IN_WKS_LIST
// m_bReady replaced by m_nReadyState
enum {STATE_NOT_READY, STATE_READY, STATE_WAIT_READY};
//---

///Jasmine 02/04/10 QA81-14754-P4 SHOW_COMMON_COL_HINT
#define COMMON_SHORT_NAME_COL_HINT		"(S)"
#define COMMON_LONG_NAME_COL_HINT		"(L)"
#define COMMON_INDEX_COL_HINT			"(I)"
///End SHOW_COMMON_COL_HINT
//---- CPY 1/2/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES
//m_nCommonColsMode = 0; 	
class CommonColsMenu : public Menu
{
public:
	CommonColsMenu(Dialog* pDlg, int nCurrent)
	{
		UINT nFlags;
		m_nChoice = -1;
		nFlags = (nCurrent == COMMCMODE_SHORT_NAMES)? MF_CHECKED | MF_ENABLED : MF_ENABLED;
		///Kenny 03/06/2009 REMOVE_TEXT_SHOW_FROM_CONTEXT_MENU
		//Add(_L("Show Columns with Common Short Names"), OnMenuItem, nFlags);
		Add(_L("Columns with Common Short Names")+COMMON_SHORT_NAME_COL_HINT, OnMenuItem, nFlags);
		nFlags = (nCurrent == COMMCMODE_LONG_NAMES)? MF_CHECKED | MF_ENABLED : MF_ENABLED;
		//Add(_L("Show Columns with Common Long Names"), OnMenuItem, nFlags);
		Add(_L("Columns with Common Long Names")+COMMON_LONG_NAME_COL_HINT, OnMenuItem, nFlags);
		nFlags = (nCurrent == COMMCMODE_COL_INDEX)? MF_CHECKED | MF_ENABLED : MF_ENABLED;
		//Add(_L("Show Columns from First Sheet and Plot Others by Column Index"), OnMenuItem, nFlags);
		Add(_L("Columns from First Sheet and Plot Others by Column Index")+COMMON_INDEX_COL_HINT, OnMenuItem, nFlags);
		///End REMOVE_TEXT_SHOW_FROM_CONTEXT_MENU
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= COMMCMODE_SHORT_NAMES && m_nChoice <= COMMCMODE_COL_INDEX)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
private:
	int	m_nChoice;
};

//----
	
////////////////////////////////////////////////////////
// class SelColsForPlottingDlg   
////////////////////////////////////////////////////////     
class SelColsForPlottingDlg : public ResizeDialog
{
public:
	SelColsForPlottingDlg(bool bNewPlot, TreeNode& trPlotList, int nPlotID = 0, int nExVal = 0) : ResizeDialog(IDD_SEL_COLS_PLOTTING, "ODlg")
	{
		m_bTemplateLib = false;
		m_bFromColList = false;
		
		if(nExVal < 0)
		{
			m_bTemplateLib = true;
			m_nMakeNewPlotExVal = 0;
		}
		else
			m_nMakeNewPlotExVal = nExVal; // for additional control info when making new plot
		
		m_bMakeNewPlot = bNewPlot;
		m_bAddToGraph = false;
		if(nPlotID > 0)
		{
			m_nPlotIDCaller = nPlotID;
			if(!bNewPlot)
				m_bAddToGraph = true;
		}
		m_nReadyState = STATE_NOT_READY;
		m_trCallerPlotList = trPlotList;
		
		m_bApplyWasDone = false;
		
		m_nCommonColsMode = COMMCMODE_SHORT_NAMES; 	//---- CPY 1/2/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES

	}
	DWORD	DoModalEx(HWND hParent)
	{
		DWORD dwRet = m_bMakeNewPlot? ADDPLOTSFROMTREE_NEW | ADDPLOTSFROMTREE_RESCALE: ADDPLOTSFROMTREE_EDIT;
		InitMsgMap();// will be called from internal later
		int nRet = DoModal(hParent);
		if(IDOK == nRet)
		{
			if (m_bFromColList)
				dwRet |= ADDPLOTSFROMTREE_IMPLICIT_STYLEHOLDERS;
			return dwRet;
		}
		return 0;
	}
	
protected:
	uint	GetCurrentPlotID(DWORD& dwAuxTypeInfo) 
	{
		return m_cntrlPlotTypes.GetCurrentPlotType(dwAuxTypeInfo);
	}
///----------------- Message Map ----------------
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_OK(OnOK)
	///------ Folger 04/13/10 REGULAR_EVENT_FUNCS_SHOULD_DO_NOTHING_AFTER_ON_DESTROY
	ON_READY(OnReady)
	///------ End REGULAR_EVENT_FUNCS_SHOULD_DO_NOTHING_AFTER_ON_DESTROY
	ON_DESTROY(OnDestroy)
	ON_BN_CLICKED(IDC_SELCOLS_SHOW_DATA, OnCheckShowWks)
	ON_BN_CLICKED(IDC_SELCOLS_SHOW_PLOTS, OnCheckShowPlots)
	
	ON_BN_CLICKED(IDC_SELCOLS_X_ERR, OnChangeErrBarOptions)
	ON_BN_CLICKED(IDC_SELCOLS_POS_NEG_ERR, OnChangeErrBarOptions)
	//ON_BN_CLICKED(IDC_SELCOLS_ADD_ROW_NUMBER, OnChangeAddRowNumbers)	///Jasmine 08/01/08 ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
	ON_BN_CLICKED(IDC_SELCOLS_APPLY_WKS, OnApplyWksDesignations)
	
#ifdef CHANGE_DESIGNATION_MODE_BTN
	ON_BN_CLICKED(IDC_SELCOLS_DESIGNATION, OnToggleDesignationMode)	///Jasmine 09/01/08 QA880-11938 ADD_CHANGE_DESIGNATION_MODE_BTN
#endif//CHANGE_DESIGNATION_MODE_BTN

	ON_BN_CLICKED(IDC_SELCOLS_ADD, OnAdd)
//	ON_BN_CLICKED(IDC_SELCOLS_EDIT, OnEdit)
#ifdef CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
	ON_BN_CLICKED(IDC_SELCOLS_REPLACE, OnReplace)			///Kyle 07/21/08 ADD_REPLACE_BUTTON_TO_DIALOG
#endif
	ON_BN_CLICKED(IDC_APPLY, OnApply) //CPY 9/16/03 

	ON_BN_CLICKED(IDC_SELCOLS_COMMON_COL_CHOICE, OnCommonColChoicePopup) //---- CPY 1/2/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES
	
	ON_BN_CLICKED(IDC_SELCOLS_INCLUDE_SHORTCUT, OnAvilableDataComboChange)	///Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE
	
	ON_CBN_SELCHANGE(IDC_SELCOLS_AVAILABLE_DATA, OnAvilableDataComboChange)
	ON_CBN_SELCHANGE(IDC_SELCOLS_PLOTS, OnDataPlotSelChange)
	
	//--- WM_USER
	ON_USER_MSG(WM_USER_ON_CONTROL_CHANGE, OnControlChange)
	ON_USER_MSG(WM_USER_RESIZE_CONTROLS, OnIncreaseDecreasePanelSize)
	
	//--- vsFlex realted
	ON_GRID_BUTTON_CLICK(IDC_SELCOLS_COLS, OnButtonClickColList)
	ON_GRID_BEFORE_EDIT(IDC_SELCOLS_COLS, OnBeforeEditColList)
	ON_GRID_AFTER_EDIT(IDC_SELCOLS_COLS, OnAfterEditColList)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_SELCOLS_COLS, OnBeforeMouseDownColList)
	ON_GRID_MOUSE_MOVE(IDC_SELCOLS_COLS, OnMouseMoveColList)
	
#ifdef CHANGE_DESIGNATION_MODE_BTN
	ON_GRID_SEL_CHANGE(IDC_SELCOLS_COLS, OnColSelChange)	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
#endif//CHANGE_DESIGNATION_MODE_BTN
	
	ON_GRID_SEL_CHANGE(IDC_SELCOLS_WKSTREE, OnWksSelChange)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_SELCOLS_WKSTREE, OnBeforeMouseDownWksList)
	
	ON_GRID_SEL_CHANGE(IDC_SELCOLS_PLOT_TYPES, OnPlotTypeChange)//---- CPY 7/30/03 PLOT_TYPE_LIST_SEL_SUPPORT
	//---	
	/// TD 8-26-03 RESIZING
	ON_SIZE(OnResize)
	ON_GETMINMAXINFO(OnMinMaxInfo)
	/// ----TD 8-26-03 RESIZING
	ON_INIT_SIZE(OnInitSize)
EVENTS_END
///----------------------------------------------

	///////////////////////////////////////////////////////
	/// Event Handlers
	///////////////////////////////////////////////////////
	BOOL OnInitDialog()
	{
		//waitCursor junk;
		PROFILE_HRGLASS
		/// RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY
		//string strRegForDlgInfo = "PlotSetupDlg"; //"SelColsForPlottingDlg";
		string strRegForDlgInfo = STR_PLOT_SETUP_DLG;
		/// end PLOT_RANGE_APPLY
		ResizeDialog::OnInitDialog();//0, STR_PLOT_SETUP_DLG);		
		
		
		m_nCommonColsMode = LoadSetting(STR_COMMON_COL_MODE, COMMCMODE_SHORT_NAMES, STR_PLOT_SETUP_DLG);
		ShowCommonColHint(m_nCommonColsMode);///Jasmine 02/04/10 QA81-14754-P4 SHOW_COMMON_COL_HINT

		initUpDownShowButtons();
		
		m_cntrlPlotTypes.Init(IDC_SELCOLS_PLOT_TYPES, IDC_SELCOLS_PLOT_TYPES_STYLEHOLDER, *this);

		///Jasmine 09/05/08 QA80-11938 REMEMBER_DESIGNATION_MODE
#ifdef CHANGE_DESIGNATION_MODE_BTN		
		m_cntrlCols.Init(IDC_SELCOLS_COLS, *this, m_nPlotIDCaller, strRegForDlgInfo, m_nMakeNewPlotExVal, IDC_SELCOLS_X_ERR, IDC_SELCOLS_POS_NEG_ERR, IDC_SELCOLS_ADD_ROW_NUMBER, IDC_SELCOLS_COLS_LABEL, IDC_SELCOLS_SHOW_ALL_COLS, IDC_SELCOLS_APPLY_WKS, IDC_SELCOLS_DESIGNATION);
#else
		m_cntrlCols.Init(IDC_SELCOLS_COLS, *this, m_nPlotIDCaller, strRegForDlgInfo, m_nMakeNewPlotExVal, IDC_SELCOLS_X_ERR, IDC_SELCOLS_POS_NEG_ERR, IDC_SELCOLS_ADD_ROW_NUMBER, IDC_SELCOLS_COLS_LABEL, IDC_SELCOLS_SHOW_ALL_COLS, IDC_SELCOLS_APPLY_WKS);
#endif//CHANGE_DESIGNATION_MODE_BTN
		///End REMEMBER_DESIGNATION_MODE
		
		//m_cntrlPlotTypes.SetPlotType(m_cntrlCols.GetPlotType(), m_nPlotIDCaller, m_nMakeNewPlotExVal);
		DWORD		dwAuxTypeInfo = 0;
		int			nPlotType = m_cntrlCols.GetPlotType(&dwAuxTypeInfo);
		m_cntrlPlotTypes.SetPlotType(nPlotType, m_nPlotIDCaller, dwAuxTypeInfo, m_nMakeNewPlotExVal);

		///Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE
		//m_cntrlWks.Init(IDC_SELCOLS_WKSTREE, *this, m_bMakeNewPlot, strRegForDlgInfo, IDC_SELCOLS_APPLY_WKS, IDC_SELCOLS_AVAILABLE_DATA);
		m_cntrlWks.Init(IDC_SELCOLS_WKSTREE, *this, m_bMakeNewPlot, strRegForDlgInfo, IDC_SELCOLS_APPLY_WKS, IDC_SELCOLS_AVAILABLE_DATA, IDC_SELCOLS_INCLUDE_SHORTCUT);
		///End OPTION_TO_GET_PAGE
		m_cntrlPlots.Init(IDC_SELCOLS_PLOTS, *this);
		
		if(!m_trCallerPlotList.DataPlots.IsValid())
			init_tree_num_layers(m_trCallerPlotList, m_cntrlCols.GetNumLayers());
		
		m_cntrlPlots.SetTree(m_trCallerPlotList);
				
		m_staticAvailDataLabel = GetItem(IDC_SELCOLS_AVAILABLE_DATA_LABEL);
		m_staticPlotListLabel = GetItem(IDC_SELCOLS_PLOTS_LABEL);
		///Kyle 07/21/08 ADD_REPLACE_BUTTON_TO_DIALOG
		//m_btnAddReplacePlot = GetItem(IDC_SELCOLS_ADD);
#ifdef CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
		m_btnAddPlot = GetItem(IDC_SELCOLS_ADD);
		m_btnReplacePlot = GetItem(IDC_SELCOLS_REPLACE);
		m_btnAddPlot.Enable = m_btnReplacePlot.Enable = false;	///Jasmine 10/16/08 QA80-12354 NO_COL_SELECTED_ON_INIT
#else
		m_btnAddReplacePlot = GetItem(IDC_SELCOLS_ADD);
		m_btnAddReplacePlot.Enable = false;						///Jasmine 10/16/08 QA80-12354 NO_COL_SELECTED_ON_INIT
		
		m_btnReplacePlot = GetItem(IDC_SELCOLS_REPLACE);
		if(m_btnReplacePlot)
			m_btnReplacePlot.Visible = false;
#endif
		///End ADD_REPLACE_BUTTON_TO_DIALOG
		m_btnOK = GetItem(IDOK);
		m_btnApply = GetItem(IDC_APPLY);
		//------ CPY 9/6/03 v7.5686 RESIZEING_CLEAN_UP
		/*
		//// save the group size so we can resize the whole dialog
		RECT r1;
		m_cntrlWks.GetRect(r1);
		m_nWksListGroupHeight = r1.bottom;
		m_cntrlCols.GetRect(r1);
		m_nPlotListGroupHeight = GetDlgExtent() - r1.bottom;
		m_nColListGroupHeight = RECT_HEIGHT(r1);
		*/
		//m_comboPlotTypes = GetItem(IDC_SELCOLS_PLOT_TYPES);
		//m_btnEditPlot = GetItem(IDC_SELCOLS_EDIT);
		//m_btnReplacePlot = GetItem(IDC_SELCOLS_REPLACE);
		
		///Jasmine 03/06/09 QA80-13219-P3 BRING_BACK_AUTO_X_MENU, show AutoX by default
		Button btn = GetItem(IDC_SELCOLS_ADD_ROW_NUMBER);
		btn.Check = true;
		///End BRING_BACK_AUTO_X_MENU
		
		//--- use diff reg section as the settings might have diff preferences between these cases
		string strRegSection = "LayerContentsDlg";
		if(m_bMakeNewPlot)
			strRegSection = strRegForDlgInfo;
		//---	 
		
		///Jasmine 11/28/08 v8.0980d QA80-12437 SHOULD_REMEMBER_DESIGNATION_AND_AUTO_DETECT_LATER
		//since insert IDC_SELCOLS_X_ERR, IDC_SELCOLS_POS_NEG_ERR in checkbox array, the old registry value is interrupted
		DWORD dwAfterInsertErrBit = 0;
		dlg_load_registry(strRegSection, "RememberErrCheckBox", dwAfterInsertErrBit);
		dlg_save_to_registry(strRegSection, "RememberErrCheckBox", 1);
		///Jasmine 09/05/08 QA80-11938 REMEMBER_DESIGNATION_MODE
		///Jasmine 08/08/08 QA80-11974 NO_NEED_REMEMBER_DESIGNATION
		//ResizeDialog::LoadCheckBoxSettings(strRegSection, IDC_SELCOLS_SHOW_DATA, IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_X_ERR, IDC_SELCOLS_POS_NEG_ERR, IDC_SELCOLS_ADD_ROW_NUMBER, IDC_SELCOLS_APPLY_WKS, IDC_SELCOLS_SHOW_ALL_COLS);
#ifdef CHANGE_DESIGNATION_MODE_BTN
		//ResizeDialog::LoadCheckBoxSettings(strRegSection, IDC_SELCOLS_SHOW_DATA, IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_ADD_ROW_NUMBER, IDC_SELCOLS_APPLY_WKS, IDC_SELCOLS_SHOW_ALL_COLS, IDC_SELCOLS_DESIGNATION);
		if(dwAfterInsertErrBit)
			ResizeDialog::LoadCheckBoxSettings(strRegSection, IDC_SELCOLS_SHOW_DATA, IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_X_ERR, IDC_SELCOLS_POS_NEG_ERR, IDC_SELCOLS_ADD_ROW_NUMBER, IDC_SELCOLS_APPLY_WKS, IDC_SELCOLS_SHOW_ALL_COLS, IDC_SELCOLS_DESIGNATION);
		///Kyle 06/23/2009 QA80-13831 SHOULD_LOAD_CHECK_BOX_SETTINGS_IN_OLD_ORDER_AND_THEN_CHANGE_IT_TO_NEW_ORDER
		else
		{
			ResizeDialog::LoadCheckBoxSettings(strRegSection, IDC_SELCOLS_SHOW_DATA, IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_ADD_ROW_NUMBER, IDC_SELCOLS_APPLY_WKS, IDC_SELCOLS_SHOW_ALL_COLS, IDC_SELCOLS_DESIGNATION);
			RememberCheckBoxes(strRegSection, IDC_SELCOLS_SHOW_DATA, IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_X_ERR, IDC_SELCOLS_POS_NEG_ERR, IDC_SELCOLS_ADD_ROW_NUMBER, IDC_SELCOLS_APPLY_WKS, IDC_SELCOLS_SHOW_ALL_COLS, IDC_SELCOLS_DESIGNATION);
		}
		///End SHOULD_LOAD_CHECK_BOX_SETTINGS_IN_OLD_ORDER_AND_THEN_CHANGE_IT_TO_NEW_ORDER
		
		vector<byte> vbCheckSettings;
		if( !load_default_checkboxes(strRegSection, vbCheckSettings) || !dwAfterInsertErrBit)
		{
			Button btn = GetItem(IDC_SELCOLS_DESIGNATION);			
			btn.Check = true;
		}
#else
		//ResizeDialog::LoadCheckBoxSettings(strRegSection, IDC_SELCOLS_SHOW_DATA, IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_ADD_ROW_NUMBER, IDC_SELCOLS_APPLY_WKS, IDC_SELCOLS_SHOW_ALL_COLS);
		if(dwAfterInsertErrBit)
			ResizeDialog::LoadCheckBoxSettings(strRegSection, IDC_SELCOLS_SHOW_DATA, IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_X_ERR, IDC_SELCOLS_POS_NEG_ERR, IDC_SELCOLS_ADD_ROW_NUMBER, IDC_SELCOLS_APPLY_WKS, IDC_SELCOLS_SHOW_ALL_COLS);
		///Kyle 06/23/2009 QA80-13831 SHOULD_LOAD_CHECK_BOX_SETTINGS_IN_OLD_ORDER_AND_THEN_CHANGE_IT_TO_NEW_ORDER
		else
		{
			ResizeDialog::LoadCheckBoxSettings(strRegSection, IDC_SELCOLS_SHOW_DATA, IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_ADD_ROW_NUMBER, IDC_SELCOLS_APPLY_WKS, IDC_SELCOLS_SHOW_ALL_COLS);
			RememberCheckBoxes(strRegSection, IDC_SELCOLS_SHOW_DATA, IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_X_ERR, IDC_SELCOLS_POS_NEG_ERR, IDC_SELCOLS_ADD_ROW_NUMBER, IDC_SELCOLS_APPLY_WKS, IDC_SELCOLS_SHOW_ALL_COLS);
		}
		///End SHOULD_LOAD_CHECK_BOX_SETTINGS_IN_OLD_ORDER_AND_THEN_CHANGE_IT_TO_NEW_ORDER
#endif//CHANGE_DESIGNATION_MODE_BTN
		///End NO_NEED_REMEMBER_DESIGNATION
		///End REMEMBER_DESIGNATION_MODE
		///End SHOULD_REMEMBER_DESIGNATION_AND_AUTO_DETECT_LATER
		
		LoadMoreCheckBoxSettings();		///Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE
		
		if(m_bAddToGraph)
		{
			m_chkShowWks.Check = true;
			m_chkShowPlots.Check = true;
		}
		else if(m_bTemplateLib)
			m_chkShowPlots.Check = true;
			
		//showWksListGroup(isAvailDataListShown());	///Jasmine 12/01/09 QA80-14144 UPDATE_WKS_LIST_AFTER_LOAD_REGIST_VALUE
		//----CPY 8/19/03, show order important, otherwise can seem like bad drawing of dialog, old code always show/hide PlotList, then follow by ColList
		if(isColListShown()) 
		{
			showPlotListGroup(isPlotListShown());
			showColListGroup(true);
		}
		else
		{
			showColListGroup(false);
			showPlotListGroup(isPlotListShown());
			
			// temp
			m_cntrlPlotTypes.SetVisible(false);
		}
		//----


		/// Kenny 08/17/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
		//m_cntrlWks.OnReady(getAvailDataListLastChoice(), m_bMakeNewPlot, dwAuxTypeInfo);// if making new plot, then sel current wks
		m_cntrlWks.OnReady(getAvailDataListLastChoice(), m_bMakeNewPlot, dwAuxTypeInfo, isColListShown());// if making new plot, then sel current wks
		/// End QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
		showWksListGroup(isAvailDataListShown());	///Jasmine 12/01/09 QA80-14144 UPDATE_WKS_LIST_AFTER_LOAD_REGIST_VALUE
		
		m_cntrlPlotTypes.OnReady(dwAuxTypeInfo, m_cntrlWks.GetCurrentPageType());
		/// RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY
		//----- CPY 1/24/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES
		//if( dlg_load_registry(STR_PLOT_SETUP_DLG, STR_PLOT_VIEW, dwView) )
		///Jasmine 09/03/08 QA80-12131 NOT_SELECT_ACTIVE_PLOT_WHEN_ADD_PLOT_TO_LAYER
		//m_cntrlPlots.OnReady(m_bMakeNewPlot, m_bTemplateLib, LoadSetting(STR_PLOT_VIEW, 0, STR_PLOT_SETUP_DLG));
		m_cntrlPlots.OnReady(m_bMakeNewPlot, m_bTemplateLib, m_bAddToGraph, LoadSetting(STR_PLOT_VIEW, 0, STR_PLOT_SETUP_DLG));
		///End NOT_SELECT_ACTIVE_PLOT_WHEN_ADD_PLOT_TO_LAYER
		//-----	
		///Kyle 07/30/08 ONREADY_OF_COLLISTCONTROL_CHANGED_AND_UPDATELIST_CALLED_IN_IT
		//m_cntrlCols.OnReady(nPageType);

		//if(!isAvailDataListShown())
			//m_cntrlCols.UpdateList();
		int nPageType = m_cntrlWks.GetCurrentPageType();
		m_cntrlCols.OnReady(nPageType);
		///End ONREADY_OF_COLLISTCONTROL_CHANGED_AND_UPDATELIST_CALLED_IN_IT
		
		if(m_bMakeNewPlot)
		{
			m_wndDlg.Text = SCP_DLG_TITLE_LEFT_NEW_PLOT;// + getCurrentPlotType();
		}
		else
			m_wndDlg.Text = SCP_DLG_TITLE_LEFT_LAYER_CONTENTS;
		
		//if ( m_btnEditPlot )
		//	m_btnEditPlot.Enable = FALSE;
		
		//if ( m_btnReplacePlot )
		//	m_btnReplacePlot.Enable = FALSE;
		//--- CPY 9/6/03 v7.5686 RESIZEING_CLEAN_UP
		AddPanel(&m_cntrlWks);
		AddPanel(&m_cntrlCols);
		AddPanel(&m_cntrlPlots);
		LoadSizeOfPanels();
		m_bFirstTimeResize = true;	///JJasmine 04/16/07 QA80-9617 RESIZE_DIALOG_AFTER_LOAD_SIZE
		//--- end CPY 9/6/03 v7.5686 RESIZEING_CLEAN_UP
		m_nReadyState = STATE_READY;
		
		/// Hong 10/29/10 ORG-974 FIX_PLOTSETUP_OPEN_WITH_COLLST_EMPTY_WITH_WXGRID
#ifdef		__REPLACE_VSFLEX_WITH_64_MP_WXGRID__		
		// Hong, I do NOT why vsflexgrid can make last row change to postmessage but not sendmessage,
		// see "m_flx.Row = nRow;" in function updateList in wkslistcontrol.h
		// so just make a simple dirty fix here to call it ourself.
		Control				junkCtrl;
		OnWksSelChange(junkCtrl);
#endif		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
		/// end FIX_PLOTSETUP_OPEN_WITH_COLLST_EMPTY_WITH_WXGRID
		
		enableOKbutton(false);// CPY, startup with OK disabled, must have proper settings to enable
		return TRUE;	
	}

	///------ Folger 04/13/10 REGULAR_EVENT_FUNCS_SHOULD_DO_NOTHING_AFTER_ON_DESTROY
	BOOL OnReady()
	{
		SetInitReady();
		return TRUE;
	}
	///------ End REGULAR_EVENT_FUNCS_SHOULD_DO_NOTHING_AFTER_ON_DESTROY

	BOOL OnInitSize(int &left, int &top, int &right, int  &bottom)
	{
		RECT rect;
		rect.left =left;
		rect.top =top;
		rect.right =right;
		rect.bottom =bottom;
		repositionPanels(true, false, &rect);

		return FALSE;
	}
	///Jasmine 08/14/09 IDC_SELCOLS_PLOTS_LABEL_WIDEN
	int	GetTotalWidth(bool bMin = false)
	{
		vector<uint> vnControls = {IDC_SELCOLS_PLOTS_LABEL, IDC_SELCOLS_SHOW_PLOTS, IDC_SELCOLS_ADD, IDC_SELCOLS_REPLACE};
		
		int nTotalWidth = 0;
		for(int ii = 0; ii < vnControls.GetSize(); ii++)
		{
			Control ctrl = GetItem( vnControls[ii] );
			if(ctrl)
			{
				RECT rr;
				ctrl.GetClientRect(&rr);
				nTotalWidth += RECT_WIDTH(rr) + GetControlGap();
			}
			else
				ASSERT(0);				
		}
		if(nTotalWidth > 0)
			nTotalWidth += GetControlGap();
		
		return nTotalWidth;
	}
	///End IDC_SELCOLS_PLOTS_LABEL_WIDEN
	BOOL OnIncreaseDecreasePanelSize(uint wParam, uint lParam)
	{
		if(ResizeDialog::OnIncreaseDecreasePanelSize(wParam, lParam))
		{
			repositionPanels();
		}
		return TRUE;
	}
	BOOL OnResize(int nType, int cx, int cy)
	{
		///Jasmine 04/16/07 QA80-9617 RESIZE_DIALOG_AFTER_LOAD_SIZE
		if(m_bFirstTimeResize)
		{
			repositionPanels();
			m_bFirstTimeResize = false;
		}
		///End RESIZE_DIALOG_AFTER_LOAD_SIZE
		if(ResizeDialog::OnResize(nType, cx, cy))
			repositionPanels();
		
		return TRUE;
	}
	BOOL OnAvilableDataComboChange( Control ctrl )
	{
		m_cntrlWks.OnAvilableDataComboChange(m_cntrlPlots.GetCurrentWks());	///Jasmine 04/10/07 QA80-9597 v597b GET_WKS_FROM_DATA_PLOT
		
		///Kyle 07/31/08 UPDATE_LIST_WHEN_NO_CONTENT
		vector<uint> vnRows;
		if(!m_cntrlWks.GetSelRows(vnRows))				//no content of the selected pagetype or no page selected
		{
			int nPageType = m_cntrlWks.GetCurrentPageType();
			m_cntrlCols.UpdateList(nPageType);
		}
		///End UPDATE_LIST_WHEN_NO_CONTENT
		return TRUE;
	}
	BOOL OnDataPlotSelChange(Control ctrl )
	{
		///------ Folger 04/13/10 REGULAR_EVENT_FUNCS_SHOULD_DO_NOTHING_AFTER_ON_DESTROY
		if ( !IsInitReady() )
			return TRUE;
		///------ End REGULAR_EVENT_FUNCS_SHOULD_DO_NOTHING_AFTER_ON_DESTROY

		//-------- CPY 8/18/03 AUTO_ENTER_EDIT_WHEN_DATAPLOT_SELECTED
		//if ( m_btnEditPlot )
		//{
		//	BOOL			bEnableEdit = m_cntrlPlots.IsEditAllowed();
		//	m_btnEditPlot.Enable = bEnableEdit;
		//}
		//m_cntrlPlots.OnSelChange(m_cntrlPlotTypes);
		if(!isReadyEventHandling(true))
			return TRUE;

		//---- CPY 9/9/03 WKS_1000_COLS_TOO_SLOW
		if(m_cntrlPlots.IsSelSameRow())
			return TRUE;
		//----
		
		m_cntrlPlots.EndEdit(m_cntrlCols);
		checkStartEdit();
		return TRUE;
	}
	BOOL OnControlChange(uint wParam, uint lParam)
	{
		// we may get here from some other internal PostMessage, so check if lParam=NULL to avoid those, 
		// sinice lparam is typically hWnd if posted internally
		/// RVD 8/25/2003 QA70-5042 v7.0674 DATAPLOT_LIMITS_DISPLAY
		//if(0== lParam && ON_CONTROL_CHANGE_COL_DESIGNATIONS == wParam)
		if( lParam )
		{
			///Jasmine 08/11/08 QA80-11948-P1 ENABLE_APPLY_WHEN_PLOT_CHANGE
			if(!m_bMakeNewPlot)
				enableOKbutton(true);
			///End ENABLE_APPLY_WHEN_PLOT_CHANGE
			short	shMsg = LOWORD(wParam);
			if (shMsg <= 0)
			{
				if(ONCTRLCHNG_DELETE_ROWS == shMsg)
				{
					short		shRow = HIWORD(wParam);
					OnRemove(shRow);// need to change 1 to layer Row
				}
					
				return TRUE;		
			}
			m_cntrlPlots.UpdateDataPlotLimits(wParam);
		}
		else if( ON_CONTROL_CHANGE_COL_DESIGNATIONS == wParam )
		/// end DATAPLOT_LIMITS_DISPLAY
		{
			//m_btnAddReplacePlot.Enable = m_cntrlCols.IsReadyAddReplacePlot();
			enablePlottingButton();
		}
		return TRUE;
	}
	BOOL OnOK()
	{		
		if(isPlotListShown())
		{
			m_bFromColList = false;
			m_cntrlPlots.GetTree(m_trCallerPlotList);
			// call to make plot
		}
		else // no need to get from control, directly make plot
		{
			Tree trLayer;
			m_bFromColList = true;
			///Jasmine 12/01/09 QA80-14762 GetDataPlots_MAY_FAIL
			//m_cntrlCols.GetDataPlots(trLayer);
			if( m_cntrlCols.GetDataPlots(trLayer) )
			{
				///Jasmine 06/04/07 QA70-9560 FIX_XYZ_CONTOUR_BUG_P1, AddDataPlots will add the necessary nodes
				//m_trCallerPlotList.DataPlots.Layer0.XML = trLayer.Layer.XML;
				vector<uint>		vnPlotIDs;
				if( m_cntrlPlotTypes.GetPlotTypes(vnPlotIDs) )
				m_cntrlPlots.AddDataPlots(trLayer, vnPlotIDs);
			}
			///End GetDataPlots_MAY_FAIL
			m_cntrlPlots.GetTree(m_trCallerPlotList);
			///End FIX_XYZ_CONTOUR_BUG_P1
		}
			
		return TRUE;
	}
	BOOL OnApply(Control cntrl)
	{
		m_bFromColList = false;
		Tree trTemp;
		m_cntrlPlots.GetTree(trTemp);
		if(trTemp.DataPlots.IsValid())
		{
			GraphPage	pg = Project.Pages();
			DWORD dwApplyFlags = ADDPLOTSFROMTREE_EDIT;
			apply_plot_list_tree_to_page(pg, trTemp.DataPlots, dwApplyFlags);
			// we need to update the layer contents after apply, so the correct tree is in the PlotList
			Tree trPlots;
			gpage_get_plots(pg, trPlots);			
			m_cntrlPlots.EndEdit(m_cntrlCols);
			updateGUIOnEditReplace(FALSE);
			m_cntrlPlots.SetTree(trPlots, true);	///jasmine 08/11/08 QA80-11984-P2 REMEMBER_SELECTED_ROW_IN_SET_TREE
			
			m_bApplyWasDone = true;
			///Jasmine 08/11/08 QA80-11948-P1 ENABLE_APPLY_WHEN_PLOT_CHANGE
			if(!m_bMakeNewPlot)
				enableOKbutton(false);
			///End ENABLE_APPLY_WHEN_PLOT_CHANGE
		}
		return TRUE;
	}
	//---- CPY 1/2/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES
	BOOL OnCommonColChoicePopup(Control cntrl)
	{
		CommonColsMenu	myMenu(this, m_nCommonColsMode);
		RECT rr;
		if(!GetControlClientRect(IDC_SELCOLS_COMMON_COL_CHOICE, rr))
			return true;
		ClientToScreen(&rr);
		myMenu.TrackPopupMenu(0,  rr.right, rr.top, GetSafeHwnd());
		int nCmd;
		if(myMenu.GetCommand(nCmd))
		{
			m_nCommonColsMode = nCmd;
			ShowCommonColHint(m_nCommonColsMode);///Jasmine 02/04/10 QA81-14754-P4 SHOW_COMMON_COL_HINT
			Control cntrlJunk;
			OnWksSelChange(cntrlJunk);
		}
		return true;
	}
	///Jasmine 02/04/10 QA81-14754-P4 SHOW_COMMON_COL_HINT
	void ShowCommonColHint(int nCommonCol)
	{
		Control ctrl = GetItem(IDC_SELCOLS_COMMON_COL_CHOICE);
		if(!ctrl)
			return;
		
		string strHint = "";
		switch(nCommonCol)
		{
		case COMMCMODE_SHORT_NAMES:
			strHint = COMMON_SHORT_NAME_COL_HINT;
			break;
		case COMMCMODE_LONG_NAMES:
			strHint = COMMON_LONG_NAME_COL_HINT;
			break;
		case COMMCMODE_COL_INDEX:
			strHint = COMMON_INDEX_COL_HINT;
			break;
		}
		
		string strText = ctrl.Text;
		int nEnd = strText.Find("(");
		if(nEnd > -1)
			strText = strText.Left(nEnd);
		ctrl.Text = strText + strHint;
	}
	///End SHOW_COMMON_COL_HINT
	//----
	BOOL OnDestroy()
	{
		///------ Folger 04/13/10 REGULAR_EVENT_FUNCS_SHOULD_DO_NOTHING_AFTER_ON_DESTROY
		SetInitReady(FALSE);
		///------ End REGULAR_EVENT_FUNCS_SHOULD_DO_NOTHING_AFTER_ON_DESTROY
		
		m_cntrlWks.OnDestroy(); //CPY 5/30/04
		
		/// RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY
		//----- CPY 1/24/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES
		//dlg_save_to_registry(STR_PLOT_SETUP_DLG, STR_PLOT_VIEW, m_cntrlPlots.GetView());
		SaveSetting(STR_PLOT_VIEW, m_cntrlPlots.GetView(), STR_PLOT_SETUP_DLG);
		SaveSetting(STR_COMMON_COL_MODE, m_nCommonColsMode, STR_PLOT_SETUP_DLG);
		//-----
		/// end PLOT_RANGE_APPLY
		saveAvailDataListLastChoice(m_cntrlWks.GetAvailableDataChoice());
		SaveCheckBoxSettings();
		SaveMoreCheckBoxSettings();		///Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE
		SaveSizeOfPanels();
		m_cntrlCols.SaveInfoColsSetting();					///Kyle 07/22/08 ADD_TWO_FUNCTION_TO_SAVE_AND_LOAD_SETTING_OF_INFO_COLS_SHOW
		return TRUE;
	}
	///Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE, SaveCheckBoxSettings is not enough now
#define STR_REG_MORE_CHECKBOX_KEY 	"MoreCheckBoxes"
#define	MORE_CHECKBOX_IDS			IDC_SELCOLS_INCLUDE_SHORTCUT	
	bool LoadMoreCheckBoxSettings()
	{
		vector<byte> vbCheckSettings;
		if( !load_default_checkboxes(STR_PLOT_SETUP_DLG, vbCheckSettings, STR_REG_MORE_CHECKBOX_KEY) )
			return false;
		
		vector<uint> vnCheckBoxes = {MORE_CHECKBOX_IDS};
		for(int ii = 0; ii < vnCheckBoxes.GetSize() && ii < vbCheckSettings.GetSize(); ii++)
		{
			Button btnCheck = GetItem( vnCheckBoxes[ii] );
			if(btnCheck)
				btnCheck.Check = vbCheckSettings[ii];
			else
				ASSERT(0);
		}
		
		return true;
		
	}
	bool SaveMoreCheckBoxSettings()
	{
		vector<uint> vnCheckBoxes = {MORE_CHECKBOX_IDS};
		vector<byte> vbValues;
		for(int ii = 0; ii < vnCheckBoxes.GetSize(); ii++)
		{
			Button btnCheck = GetItem( vnCheckBoxes[ii] );
			if(btnCheck)
				vbValues.Add( btnCheck.Check );
			else
				ASSERT(0);
		}
		
		return save_default_checkboxes(STR_PLOT_SETUP_DLG, vbValues, STR_REG_MORE_CHECKBOX_KEY);
	}
	///End OPTION_TO_GET_PAGE
	BOOL OnAdd(Control cntrl)
	{
		///Kyle 07/21/08 ADD_REPLACE_BUTTON_TO_DIALOG
		//if(m_cntrlCols.IsInEditMode())
		//{
			////updateGUIOnEditReplace(FALSE); CPY 9/3/03 this is removed since Replace will no longer change selection after Marko changed in TreeEditor
			//return doAddOrReplace(TRUE);
		//}
#ifndef CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
		if(m_cntrlCols.IsInEditMode())
			return doAddOrReplace(TRUE);
#endif
		///End ADD_REPLACE_BUTTON_TO_DIALOG
		doAddOrReplace();
#ifdef CHANGE_DESIGNATION_MODE_BTN			
		if(	m_cntrlCols.IsDesignationMode() )	///Jasmine 10/15/08 QA80-12369 INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION
#endif
		m_cntrlCols.ClearAllDesignations();
		return TRUE;
	}

	///Kyle 07/21/08 ADD_REPLACE_BUTTON_TO_DIALOG
#ifdef CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
	BOOL OnReplace(Control cntrl)
	{
		return doAddOrReplace(TRUE);
	}
#endif
	///End ADD_REPLACE_BUTTON_TO_DIALOG
	void OnRemove(int nRowToSel)
	{
		m_cntrlPlots.OnRemove(nRowToSel);
	}
	void OnChangeAddRowNumbers(Control cntrl)
	{
		m_cntrlCols.OnChangeAddRowNumbers();
	}
	void OnChangeErrBarOptions(Control cntrl)
	{
		m_cntrlCols.OnChangeErrBarOptions();
	}
//public:
	//---- CPY 7/30/03 PLOT_TYPE_LIST_SEL_SUPPORT
	void OnPlotTypeChange(Control cntrl)
	{
		/// ML 9/28/2003
		//if(isReadyEventHandling())
		if(isReadyEventHandling(true))
		{
			m_cntrlPlotTypes.OnPlotTypeChange(m_cntrlCols);

			///Jasmine 02/04/10 QA81-14467-P2 NOT_RESET_COL_DESIG_OF_SEL_PLOT
			int nPlotListSelType = m_cntrlPlots.GetSelectedType();
			if(DPL_PLOT_OUTSIDE_GROUP != nPlotListSelType && DPL_PLOT_IN_GROUP != nPlotListSelType)
			///End NOT_RESET_COL_DESIG_OF_SEL_PLOT
			{
				///Jasmine 10/28/09 QA80-14467 COL_DESIGNATION_NEED_UPDATE_BY_PLOT_TYPE
				m_cntrlWks.OnSelChange(m_cntrlCols, m_nCommonColsMode);
				///End COL_DESIGNATION_NEED_UPDATE_BY_PLOT_TYPE
			}
		}
	}
	//----
	void OnApplyWksDesignations(Control cntrl)
	{
		Button chkboxApplyWks = cntrl;
		if(chkboxApplyWks.Check)
			m_cntrlCols.ApplyWksColDesignations(true);
	}
	
	///Jasmine 09/01/08 QA880-11938 ADD_CHANGE_DESIGNATION_MODE_BTN
#ifdef CHANGE_DESIGNATION_MODE_BTN	
	void OnToggleDesignationMode(Control cntrl)
	{
		m_cntrlCols.OnToggleDesignationMode();
	}
#endif//CHANGE_DESIGNATION_MODE_BTN
	///End ADD_CHANGE_DESIGNATION_MODE_BTN
	
	void OnBeforeMouseDownWksList(Control flxControl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
	{
		if(isReadyEventHandling(true))
		{
#ifdef CHANGE_DESIGNATION_MODE_BTN			
			bool bDesignation = m_cntrlCols.IsDesignationMode();	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
			m_cntrlWks.OnBeforeMouseDown(m_cntrlCols, nButton, nShift, X, Y, bDesignation, pCancel);
#else
			m_cntrlWks.OnBeforeMouseDown(m_cntrlCols, nButton, nShift, X, Y, pCancel);
#endif//CHANGE_DESIGNATION_MODE_BTN
		}
	}
	void OnWksSelChange(Control flxControl)
	{
		if(isReadyEventHandling())
		{
			//printf("m_bReady and OnWksSelChange\n");
			//--------- CPY 9/6/04 QA70-6831 REPLACE_PLOT_WITH_ANOTHER_WKS
			//m_cntrlPlots.OnWksSelChange(m_cntrlCols);	//---- CPY 9/25/03 v7.5707 EDIT_PLOT_SHOW_HIGHLIGHT_IN_WKS_LIST
			if(!isInEditMode())
				m_cntrlPlots.OnWksSelChange(m_cntrlCols);
			//--------- end REPLACE_PLOT_WITH_ANOTHER_WKS
			int nPageType = m_cntrlWks.OnSelChange(m_cntrlCols, m_nCommonColsMode);
			bool bIncludeStyleHolders = m_cntrlPlots.HasStyleHolders();
			///Sophy 8/3/2010 ORG-681-P2 PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
			//bool bRetOK = m_cntrlPlotTypes.OnNewPageType(nPageType, bIncludeStyleHolders);
			bool bRetOK = m_cntrlPlotTypes.OnNewPageType(nPageType, bIncludeStyleHolders, m_cntrlCols.IsVirtualMatrix());
			///end PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
			m_cntrlPlotTypes.OnPlotTypeChange(m_cntrlCols, bRetOK);

		}
	}
	void OnCheckShowWks(Control cntrl)
	{
		showWksListGroup(isAvailDataListShown());
		repositionPanels(true, true);
	}
	void OnCheckShowPlots(Control cntrl)
	{
		if(m_bMakeNewPlot)
		{
			showPlotListGroup(isPlotListShown());
			repositionPanels();
			
			enablePlottingButton();		///Jasmine 10/16/08 QA80-12354 TOO_LATE_TO_ENABLE_ADDREPLACE_BTN_WHEN_SHOW_BTN
			
			//if(m_btnAddReplacePlot.Visible)
#ifdef CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
			if(m_btnAddPlot.Visible)
#else
			if(m_btnAddReplacePlot.Visible)
#endif
				enableOKbutton(false, true);
			//else
				//enablePlottingButton();
		}
		else
		{
 			showColListGroup(isColListShown());
			repositionPanels(true, true);
		}
	}
	//// vsFlex events
	void OnButtonClickColList(Control flxControl, int nRow, int nCol)
	{
		m_cntrlCols.OnButtonClick(flxControl, nRow, nCol);
	}
	void OnAfterEditColList(Control flxControl, int nRow, int nCol)
	{
		m_cntrlCols.OnAfterEdit(flxControl, nRow, nCol);
	}
	void OnBeforeEditColList(Control cntrl, long nRow, long nCol, BOOL* pCancel)
	{
		m_cntrlCols.OnBeforeEdit(cntrl, nRow, nCol, pCancel);
	}
	void OnBeforeMouseDownColList(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
	{
		m_cntrlCols.OnBeforeMouseDown(cntrl, nButton, nShift, X, Y, pCancel);
	}
	void OnMouseMoveColList(Control cntrl, short nButton, short nShift, float X, float Y)
	{
		m_cntrlCols.OnMouseMove(cntrl, nButton, nShift, X, Y);
	}
	
#ifdef CHANGE_DESIGNATION_MODE_BTN	
	void OnColSelChange(Control flxControl)
	{
		m_cntrlCols.OnColSelChange();	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
	}
#endif//CHANGE_DESIGNATION_MODE_BTN
		
private:
	void initUpDownShowButtons()
	{
		m_chkShowWks = GetItem(IDC_SELCOLS_SHOW_DATA);
		m_chkShowPlots = GetItem(IDC_SELCOLS_SHOW_PLOTS);

		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.SetSize(2);
		vstrTipsUpDown[0] = _L("Show Available Data");
		vstrTipsUpDown[1] = _L("Hide Available Data");
		m_chkShowWks.Init(2, IDB_UPDOWN_BTN, 12, vstrTipsUpDown);
			
		if(m_bMakeNewPlot)
		{
			vstrTipsUpDown[0] = _L("Show Plot List");
			vstrTipsUpDown[1] = _L("Hide Plot List");
			m_chkShowPlots.Init(2, IDB_DOWNUP_BTN, 12, vstrTipsUpDown);
		}
		else
		{
			vstrTipsUpDown[0] = _L("Show Plot Designations");
			vstrTipsUpDown[1] = _L("Hide Plot Designations");
			m_chkShowPlots.Init(2, IDB_UPDOWN_BTN, 12, vstrTipsUpDown);
		}
	}
	BOOL	updateGUIOnEditReplace(BOOL bEdit)  // bEdit is TRUE OnEdit and FALSE on Replace/Cancel
	{
		if (bEdit)
		{
			//m_btnAddReplacePlot.Text = _L("Replace");
#ifdef CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
			m_btnAddPlot.Enable = 					///Jasmine 11/04/08 8.0965 ADD_BTN_ENABLE_IMPROPERLY
			m_btnReplacePlot.Enable = true;			///Kyle 07/21/08 ADD_REPLACE_BUTTON_TO_DIALOG
#else
			m_btnAddReplacePlot.Text = _L("Replace");
#endif
		}
		else
		{
			//------ Folger 02/19/08 QA80-11121 LOCALIZED_ADD_WITH_PLOT_CATEGORY
			//m_btnAddReplacePlot.Text = _L("Add");
			//m_btnAddReplacePlot.Text = _LC("Add", "Plot");
			//------
			// need to tell other controls
#ifdef CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
			m_btnAddPlot.Enable = 					///Jasmine 11/04/08 8.0965 ADD_BTN_ENABLE_IMPROPERLY
			m_btnReplacePlot.Enable = false;		///Kyle 07/21/08 ADD_REPLACE_BUTTON_TO_DIALOG
#else
			m_btnAddReplacePlot.Text = _LC("Add", "Plot");
#endif
			m_cntrlPlotTypes.OnEndEditPlot();
		}
		return TRUE;
	}
	bool isInEditMode() 
	{
		///Kyle 07/21/08 ADD_REPLACE_BUTTON_TO_DIALOG
		//if(m_btnAddReplacePlot)
		//{
			//if(m_btnAddReplacePlot.Visible && m_btnAddReplacePlot.Enable && m_cntrlCols.IsInEditMode())
				//return true;
		//}
#ifdef CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
		if(m_btnAddPlot)
		{
			if(m_btnAddPlot.Visible && m_btnAddPlot.Enable && m_cntrlCols.IsInEditMode())
				return true;
		}
#else
		if(m_btnAddReplacePlot)
		{
			if(m_btnAddReplacePlot.Visible && m_btnAddReplacePlot.Enable && m_cntrlCols.IsInEditMode())
				return true;
		}
#endif
		///End ADD_REPLACE_BUTTON_TO_DIALOG
		return false;
	}
	BOOL doAddOrReplace(BOOL bReplace = FALSE)
	{
		HOUR_GLASS //PROFILE_HRGLASS
		
		Tree	trDPList;
		/// ML 4/12/2007 QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
		///// RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY
		////if(m_cntrlCols.GetDataPlots(trDPList))
		//if(m_cntrlCols.GetDataPlots(trDPList, false, m_cntrlPlots.GetView()))
		///// end PLOT_RANGE_APPLY
		DWORD	dw = m_cntrlPlots.GetView();
		if (bReplace)
			dw |= DPEDTVIEW_REPLACE;
		
		if(m_cntrlCols.GetDataPlots(trDPList, false, dw))
		/// end PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
		{
			if (bReplace)
			{
				enableOKbutton(true);
				return m_cntrlPlots.AddDataPlots(trDPList, bReplace);
			}
			else
			{
				vector<uint>		vnPlotIDs;
				if ( m_cntrlPlotTypes.GetPlotTypes(vnPlotIDs) )
				{
					enableOKbutton(true);
					return m_cntrlPlots.AddDataPlots(trDPList, vnPlotIDs);
				}
			}
		}
		return FALSE;
	}
	
	void showWksListGroup(bool bShow)
	{
		/// Kenny 08/17/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
		if ( bShow )
		{
			m_cntrlWks.UpdateList();
		}
		/// End QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
		ShowControls(s_nWksListCntrlIDs, bShow);
//		if(!m_chkShowPlots.Visible) // Layer Contents must be show, that means we must connect the other two together
//			showColListGroup(bShow);
	}
	void showPlotListGroup(bool bShow)
	{
		uint nNewPlotCntrlIDs[] = {IDC_SELCOLS_PLOTS_LABEL, IDC_SELCOLS_PLOTS,  0};
		uint nLayerContentsCntrlIDs[] = {IDC_SELCOLS_SHOW_COLS, IDC_SELCOLS_PLOTS_LABEL, IDC_SELCOLS_PLOTS,  0};
		if(m_bMakeNewPlot)
			ShowControls(nNewPlotCntrlIDs, bShow);
		else
			ShowControls(nLayerContentsCntrlIDs, bShow);
			
		showLayerContentsEditButtons();
	}
	// col plot designation box is always show, but the plot type list may be not
	void showColListGroup(bool bShow)
	{
		if(m_bMakeNewPlot)
			ShowControls(s_nColListCntrlIDs, bShow);
		else
		{
			if(!bShow && m_chkShowWks.Check)
			{
				m_chkShowWks.Check = false;
				showWksListGroup(false);
			}
			ShowControls(&s_nColListCntrlIDs[OFFSET_COL_LIST_LAYER_CONTENTS], bShow);
			//---- CPY 10/26/03 AUTO_SEL_LAST_ACTIVE_WKS_MATRIX 
			if(bShow && !isInEditMode())
				checkStartEdit(false);
			//---- end AUTO_SEL_LAST_ACTIVE_WKS_MATRIX
			
			///Jasmine 08/27/10 ORG-928 PLOT_TYPES_STYLEHOLDER_WAS_IGNORED
			if(!bShow)
				GetItem(IDC_SELCOLS_PLOT_TYPES_STYLEHOLDER).Visible = false;
			else
			{
				 int nPlotListSelType = m_cntrlPlots.GetSelectedType();
				 m_cntrlPlotTypes.OnChangeTarget(nPlotListSelType, m_cntrlCols);
			}
			///End PLOT_TYPES_STYLEHOLDER_WAS_IGNORED
		}
		showLayerContentsEditButtons();
		
#ifndef CHANGE_DESIGNATION_MODE_BTN	
		GetItem(IDC_SELCOLS_DESIGNATION).Visible = false;
#endif//CHANGE_DESIGNATION_MODE_BTN
	}
	// LayerContents buttons should be shown only if both ColList and PlotList are both visible
	void showLayerContentsEditButtons()
	{
		bool bShow = (m_cntrlCols.IsVisible() && m_cntrlPlots.IsVisible())? true:false;
		ShowControls(s_nCntrlButtons, bShow);
	}
	string getCurrentPlotType()
	{
		DWORD dwAuxTypeInfo;
		int nPlotType = GetCurrentPlotID(dwAuxTypeInfo);//Project.GetPlotTypeInfo(GetCurrentPlotID(), dwAuxTypeInfo, dwAuxPlotInfo, strColPattern);
		return GetPlotTypeName(nPlotType, dwAuxTypeInfo); // need to convert to text later from internal
	}
	//virtual 
	BYTE GetPanelsOrientation()
	{
		return PANEL_ORIENT_VERTICAL;
	}
	//virtual
	void repositionPanels(bool bResizeDlg = true, bool bMoveDlgUpDown = false, RECT *pDlgRect = NULL)
	{
		//---- CPY 3/20/05 QA70-7459 CENTRALIZED_MOVE_CONTROL_WITH_BETTER_REDRAW
		//SetMoveRepaint(false);
		//MoveControlsHelper	_temp(this);
		//---
		int cx = pDlgRect ? (pDlgRect->right - pDlgRect->left) : GetDlgExtent(false);
		int ny = positionWksListGroup(0, cx);
		ny = positionColListGroup(ny, cx);
		ny = positionPlotListGroup(ny, cx);
		ny = positionShowChecksAndOKCancel(ny, cx);
		if(bResizeDlg)
		{
			int ndy = ny - GetDlgExtent();
			ny += GetControlGap();
			RECT rWnd;
			m_wndDlg.GetWindowRect(&rWnd);
			if(bMoveDlgUpDown)
				rWnd.top -= ndy;
			else
				rWnd.bottom += ndy;
			
			if(rWnd.top < 0)
			{
				rWnd.bottom -= rWnd.top;
				rWnd.top = 0;
			}
			/// TD 8-26-03 RESIZING
			DisableOnSize();
			/// ----TD 8-26-03 RESIZING
			/// TD 9-9-03 RPOSIZION_TO_ORIGINAL_SIZE
			if(pDlgRect)
			{
				rWnd.bottom -= rWnd.top - pDlgRect->top;
				rWnd.top = pDlgRect->top;
				rWnd.left = pDlgRect->left;
				rWnd.right = rWnd.left +cx;
			}
			/// end RPOSIZION_TO_ORIGINAL_SIZE
			m_wndDlg.MoveWindow(&rWnd);
			/// TD 8-26-03 RESIZING
			DisableOnSize(false);
			/// ----TD 8-26-03 RESIZING
			UpdateWindow();
			
			SaveDlgHeight();//--- CPY 9/6/03 v7.5686 RESIZEING_CLEAN_UP
		}
		//SetMoveRepaint(true);
	}
	int positionWksListGroup(int ny, int cx)
	{
		int nx = GetControlGap();
		if(isAvailDataListShown())
		{
			//uint nCntrlIDs[] = {IDC_SELCOLS_AVAILABLE_DATA_LABEL, IDC_SELCOLS_AVAILABLE_DATA, IDC_SELCOLS_APPLY_WKS_LABEL, IDC_SELCOLS_APPLY_WKS, 0};
			int nx1 = ArrangeControlsTopDown(&s_nWksListCntrlIDs[OFFSET_WKS_LIST_SUPPORT_ITEMS], nx, ny, GetControlGap());
			ny = StretchControlWide(IDC_SELCOLS_WKSTREE, nx1 + GetControlGap(), ny, cx); 
		}
		return ny;
	}
	int positionColListGroup(int ny, int cx)
	{
		int nEdge = GetControlGap();
		int nx = nEdge;
		// assume always show
		//	uint nCntrlIDs[] = {IDC_SELCOLS_PLOT_TYPES, IDC_SELCOLS_X_ERR, IDC_SELCOLS_POS_NEG_ERR, IDC_SELCOLS_ADD_ROW_NUMBER, 0};
		if(ny > 0)
			ny += nEdge;
		
		///Jasmine 07/16/09 #13952 HIDDEN_CONTROL_IS_IGNORED_IN_MOVING_AND_APPEAR_IN_BAD_POSITION 
		//int nx1 = ArrangeControlsTopDown(&s_nColListCntrlIDs[OFFSET_COL_LIST_SUPPORT_ITEMS], nx, ny, 0);
		int nx1 = ArrangeControlsTopDown(&s_nColListCntrlIDs[OFFSET_COL_LIST_SUPPORT_ITEMS], nx, ny, 0, NULL, 0, true);//true=bForceResize
		//End HIDDEN_CONTROL_IS_IGNORED_IN_MOVING_AND_APPEAR_IN_BAD_POSITION
		
		//---- CPY 1/2/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES
		//ny = StretchControlLeftRight(IDC_SELCOLS_COLS_LABEL, IDC_SELCOLS_SHOW_DATA, nx1 + GetControlGap(), ny, cx);
		int nBtnWidth = 0;
		MoveControl(IDC_SELCOLS_COMMON_COL_CHOICE, nx1+nEdge, ny, true, &nBtnWidth);
		
		///Jasmine 09/01/08 QA880-11938 ADD_CHANGE_DESIGNATION_MODE_BTN
#ifdef CHANGE_DESIGNATION_MODE_BTN
		vector<uint> vnCntrlIDs = {IDC_SELCOLS_COLS_LABEL, IDC_SELCOLS_DESIGNATION, IDC_SELCOLS_SHOW_DATA, 0};	///Jasmine 10/06/08 MISSING_0_MAKE_ArrangeControlsLeftRight_FAIL
		ny = ArrangeControlsLeftRight(vnCntrlIDs, nx1 + nEdge + nBtnWidth + nEdge, ny, cx, IDC_SELCOLS_COLS_LABEL, nEdge);
#else
		ny = StretchControlLeftRight(IDC_SELCOLS_COLS_LABEL, IDC_SELCOLS_SHOW_DATA, nx1 + nEdge + nBtnWidth + nEdge, ny, cx);		
#endif//CHANGE_DESIGNATION_MODE_BTN
		///End ADD_CHANGE_DESIGNATION_MODE_BTN
		
		//----
		PositionControl(IDC_SELCOLS_PLOT_TYPES_STYLEHOLDER, nx, ny, true, false);
		ny = StretchControlWide(IDC_SELCOLS_COLS, nx1 + GetControlGap(), ny, cx);
		//---- CPY 7/30/03
		vector<uint> vnGrids = {IDC_SELCOLS_COLS, IDC_SELCOLS_PLOT_TYPES, 0};
		MakeSameSize(vnGrids);
		//----
		return ny;
	}
	
	int positionPlotListGroup(int ny, int cx)
	{
		int nx = GetControlGap();
		if(m_cntrlPlots.IsVisible())
		{
			if(ny > 0)
				ny+= GetControlGap();
			Control cntrl = GetItem(s_nCntrlButtons[0]);
			if(cntrl.Visible)
				ny = ArrangeControlsRightLeft(s_nCntrlButtonsShowPlotList, cx, ny);
			else
			{
				/*
				RECT r1;
				cntrl.GetWindowRect(&r1);
				ny += RECT_HEIGHT(r1);
				*/
				uint nShowColList[] = {IDC_SELCOLS_SHOW_COLS, 0};
				ny = ArrangeControlsRightLeft(nShowColList, cx, ny);
			}
			
			///Jasmine 08/27/10 ORG-928 PLOTS_LABEL_IS_TOO_BLG_TO_SHOW_IN_OLD_LOGIC
			//ny+= GetControlGap();
			//PositionControl(IDC_SELCOLS_PLOTS_LABEL, nx, ny, false);
			RECT rrShowBtn;
			GetControlClientRect(IDC_SELCOLS_SHOW_COLS, rrShowBtn);
			ny = PositionControl(IDC_SELCOLS_PLOTS_LABEL, nx, rrShowBtn.top, true);
			ny+= GetControlGap();
			///End PLOTS_LABEL_IS_TOO_BLG_TO_SHOW_IN_OLD_LOGIC
			
			ny = StretchControlWide(IDC_SELCOLS_PLOTS, nx, ny, cx); 
		}
		return ny;
	}
	int positionShowChecksAndOKCancel(int ny, int cx)
	{
		uint nNoPlotListCntrlIDs[] = {IDC_SELCOLS_SHOW_PLOTS, IDCANCEL, IDOK, 0};// IDC_SELCOLS_SHOW_DATA, IDC_SELCOLS_SHOW_PLOTS, 0};
		uint nHasPlotListCntrlIDs[] = {IDC_APPLY, IDCANCEL, IDOK, 0};// IDC_SELCOLS_SHOW_DATA, IDC_SELCOLS_SHOW_PLOTS, 0};
		ny+= GetControlGap();
		if(m_cntrlPlots.IsVisible())
		{
			//--- CPY 9/6/04 QA70-6831 APPLY_BUTTON_SHOWING_IN_COL_LIST
			m_btnApply.Visible = true;
			//---
			return ArrangeControlsRightLeft(nHasPlotListCntrlIDs, cx, ny);
		}
		else
		{
			//--- CPY 9/6/04 QA70-6831 APPLY_BUTTON_SHOWING_IN_COL_LIST
			m_btnApply.Visible = false;
			//---
			return ArrangeControlsRightLeft(nNoPlotListCntrlIDs, cx, ny);
		}
	}
	bool isColListShown()
	{
		if(m_bMakeNewPlot)
			return true;
		
		return m_chkShowPlots.Check;
	}
	bool isPlotListShown()
	{
		if(!m_bMakeNewPlot)
			return true;
		
		return m_chkShowPlots.Check;
	}
	bool isAvailDataListShown()
	{
		return m_chkShowWks.Check;
	}
	int getAvailDataListLastChoice()
	{
		// valled after LoadCheckBoxSettings for dialog, so can skip dialog name
		return LoadSetting(STR_AVAIL_DATA_CHOICE, -1);
	}
	void saveAvailDataListLastChoice(int nSel)
	{
		SaveSetting(STR_AVAIL_DATA_CHOICE, nSel);
	}
	//virtual 
	string GetRuntimeClass()
	{
		return "PlotSetup";
	}
	void enablePlottingButton()
	{
		bool bEnable = m_cntrlCols.IsReadyAddReplacePlot();
#ifdef CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
		if(m_btnAddPlot.Visible)
		{
			//---Jasmine 11/04/08 QA80-12163 8.0965 IN_EDIT_MODE_ADD_BTN_NO_NEED_CHECK_HAS_TOO_MANY_Y
			//m_btnAddPlot.Enable = bEnable;
			bool bAddPlot = m_cntrlCols.IsReadyAddReplacePlot(false);
			///Jasmine 11/04/08 8.0965 ADD_BTN_ENABLE_IMPROPERLY
			if(bAddPlot)
			{
				vector<uint> vnRows;
				m_cntrlPlots.GetSelRows(vnRows);
				bAddPlot = 1 == vnRows.GetSize();	
			}
			///End ADD_BTN_ENABLE_IMPROPERLY
			m_btnAddPlot.Enable = bAddPlot;
			//---
			m_btnReplacePlot.Enable = bEnable && m_cntrlPlots.IsEditAllowed();		///Kyle 07/21/08 ADD_REPLACE_BUTTON_TO_DIALOG
		}
#else		
		if(m_btnAddReplacePlot.Visible)
			m_btnAddReplacePlot.Enable = bEnable;
#endif
		else if (m_bMakeNewPlot)
			m_btnOK.Enable = bEnable;
	}
	void enableOKbutton(bool bEnable, bool bTestPlotExist = false)
	{
		if(!m_bMakeNewPlot)
		{
			m_btnApply.Enable = bEnable;//true;	///Jasmine 08/11/08 QA80-11948-P1 ENABLE_APPLY_WHEN_PLOT_CHANGE
			return; // only when making new plot that we need to disable OK button
		}
		//if(!m_btnAddReplacePlot.Visible)
		//	return; // if Add button invisible, then OK button was not controlled by plot list info
		
		if(bTestPlotExist)
		{
			bEnable = m_cntrlPlots.HasDataPlots();
		}
		m_btnOK.Enable = bEnable;
		m_btnApply.Enable = false;// if making new plot, can never apply
	}
	bool isReadyEventHandling(bool bCheckWaitReadyState = false)
	{
		if(bCheckWaitReadyState && STATE_WAIT_READY == m_nReadyState)
			m_nReadyState = STATE_READY;

		return STATE_READY == m_nReadyState? true:false;
	}
	//------ CPY 10/26/03 AUTO_SEL_LAST_ACTIVE_WKS_MATRIX
	// separete this out to be reused
	void checkStartEdit(bool bOnSelChange = true)
	{
		updateGUIOnEditReplace(FALSE);

		bool bEnableEdit = m_cntrlCols.IsVisible() && m_cntrlPlots.IsEditAllowed();
		
		if(bOnSelChange)
		{
			m_cntrlPlots.OnSelChange(m_cntrlPlotTypes, m_cntrlCols);
			///Jasmine 09/21/09 QA81-14344 LAYER_BIT_WILL_AFFECT_COL_DESIGNATION
			Control ctrl;
			OnPlotTypeChange(ctrl);
			///End LAYER_BIT_WILL_AFFECT_COL_DESIGNATION
		}
		
		if(bEnableEdit)
		{
			m_nReadyState = STATE_NOT_READY;
			if(m_cntrlPlots.StartEdit(m_cntrlCols, m_cntrlPlotTypes, m_cntrlWks))
			{
				updateGUIOnEditReplace(TRUE);
			}
			m_nReadyState = STATE_WAIT_READY;
		}
		//---Jasmine 11/04/08 8.0965 ADD_BTN_ENABLE_IMPROPERLY
		else
			enablePlottingButton();
		//---
	}
	//------ end AUTO_SEL_LAST_ACTIVE_WKS_MATRIX
private:
	//bool	m_bReady;
	int		m_nReadyState;
	bool	m_bFirstTimeResize;	///Jasmine 04/16/07 QA80-9617 RESIZE_DIALOG_AFTER_LOAD_SIZE
	bool	m_bMakeNewPlot;
	bool	m_bTemplateLib;
	bool	m_bAddToGraph;
	int		m_nMakeNewPlotExVal;
	int		m_nPlotIDCaller; // the id passed in when class started
	bool	m_bFromColList;		// does the tree (on OK) come from the second table?
	int		m_nWksListGroupHeight;
	int		m_nPlotListGroupHeight;
	int		m_nColListGroupHeight;
	
	int		m_nCommonColsMode; 	//---- CPY 1/2/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES

	/// TD 8-26-03 RESIZING

	//int		m_nWksTreeHt;
	//int		m_nPlotTypeHt;
	//int		m_nPlotsHt;
	//bool	m_bDoNotHandleOnSize;
	/// ----TD 8-26-03 RESIZING
private:
	TreeNode	m_trCallerPlotList; // tree from caller
	// main tables
	WksListControl		m_cntrlWks;			// AD
	ColListControl		m_cntrlCols;		// PD
	PlotListControl		m_cntrlPlots;		// DP
	
	//
	PlotTypeListControl	m_cntrlPlotTypes;	// just a list of plot types available to this dialog
	/// other controls
	//Button	m_chkShowWks;
	//Button	m_chkShowPlots;
	BitmapRadioButton	m_chkShowWks;	
	BitmapRadioButton	m_chkShowPlots;
	Control m_staticAvailDataLabel;
	Control m_staticPlotListLabel;
	//Button	m_btnEditPlot;
#ifdef CHANGE_THE_INCORPORATE_ADD_REPLACE_BUTTON_INTO_TWO_SEPARATE_BUTTONS
	Button	m_btnAddPlot;
#else
	Button	m_btnAddReplacePlot;
#endif
	Button	m_btnReplacePlot;			///Kyle 07/21/08 ADD_REPLACE_BUTTON_TO_DIALOG
	Control	m_btnOK;
	Control	m_btnApply;
	bool	m_bApplyWasDone;
};


